package pantheon.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import pantheon.PageService;
import pantheon.model.Page;

public class PageListController implements Controller {
	protected final Log logger = LogFactory.getLog(getClass());

	private String viewName;
	private PageService pageService;

	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		List<Page> pageList = pageService.findAll();

		Map<String, Object> myModel = new HashMap<String, Object>();
		myModel.put("pageList", pageList);

		return new ModelAndView(viewName, "model", myModel);
	}

	@Required
	public void setViewName(String viewName) {
		this.viewName = viewName;
	}

	@Required
	public void setPageService(PageService pageService) {
		this.pageService = pageService;
	}

}
