package pantheon.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import pantheon.ItemService;
import pantheon.model.Item;
import pantheon.model.ItemType;

public class ItemHistoryListController implements Controller {
	protected final Log logger = LogFactory.getLog(getClass());
	private String viewName;
	private ItemType itemType;
	private ItemService itemService;

	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String sItemId = request.getParameter("itemId");
		if (!StringUtils.isNumeric(sItemId)) {
			return new ModelAndView("/403.html");
		}
		long itemId = Long.valueOf(sItemId);

		List<Item> itemList = itemService.findAllHistory(itemId);

		Map<String, Object> myModel = new HashMap<String, Object>();
		myModel.put("itemList", itemList);
		myModel.put("itemType", itemType);

		return new ModelAndView(viewName, myModel);

	}

	@Required
	public void setViewName(String viewName) {
		this.viewName = viewName;
	}

	@Required
	public void setItemType(String itemType) {
		this.itemType = ItemType.valueOf(itemType);
	}

	@Required
	public void setItemService(ItemService itemService) {
		this.itemService = itemService;
	}

}
