package pantheon.web;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

import pantheon.model.User;

public class CreateUserValidator extends AbstractPantheonValidator {

	@SuppressWarnings("unchecked")
	public boolean supports(Class clazz) {
		return LoginUserCommand.class.equals(clazz);
	}

	public void validate(Object obj, Errors errors) {
		Assert.notNull(obj);
		LoginUserCommand command = (LoginUserCommand) obj;

		// **************************
		// ユーザ名
		// **************************
		String currentField = "name";
		String currentValue = command.getName();

		if (StringUtils.isBlank(currentValue)) {
			rejectBlankError(errors, currentField, "名前");
		}
		if (!errors.hasFieldErrors(currentField) && User.NAME_LENGTH < currentValue.length()) {
			rejectOverLengthError(errors, currentField, "名前", User.NAME_LENGTH);
		}

		// **************************
		// パスワード
		// **************************
		currentField = "password";
		currentValue = command.getPassword();
		if (StringUtils.isBlank(currentValue)) {
			rejectBlankError(errors, currentField, "パスワード");
		}
		if (!errors.hasFieldErrors(currentField) && User.PASSWORD_LENGTH < currentValue.length()) {
			rejectOverLengthError(errors, currentField, "パスワード", User.PASSWORD_LENGTH);
		}
		if (!errors.hasFieldErrors(currentField) && !StringUtils.isAlphanumeric(currentValue)) {
			rejectAlphanumericError(errors, currentField, "パスワード");
		}

		// **************************
		// 備考
		// **************************
		currentField = "note";
		currentValue = command.getNote();

		if (StringUtils.isNotBlank(currentValue) && User.NOTE_LENGTH < currentValue.length()) {
			rejectOverLengthError(errors, currentField, "備考", User.NOTE_LENGTH);
		}
	}

}