package pantheon.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;

import pantheon.LoginService;
import pantheon.user.UserType;

public class CreateUserController extends SimpleFormController {
	/** Logger for this class and subclasses */
	protected final Log logger = LogFactory.getLog(getClass());
	private LoginService loginService;

	public CreateUserController() {
		super();
		setCommandName("LoginUserCommand");
		setCommandClass(LoginUserCommand.class);
	}

	@Override
	protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
		LoginUserCommand userCommand = (LoginUserCommand) command;

		// 名前重複チェック
		if (loginService.findByName(userCommand.getName()) != null) {
			ObjectError error = new FieldError("LoginUserCommand", "name", ValidatorError.editSameNameErrMessage(userCommand.getName()));
			errors.addError(error);
			return super.showForm(request, response, errors);
		}

		String encordedPassword = DigestUtils.md5Hex(userCommand.getPassword());
		loginService.createUser(UserType.ROLE_USER, userCommand.getName(), encordedPassword, userCommand.getNote());

		return new ModelAndView(new RedirectView(getSuccessView()));
	}

	@Required
	public void setLoginService(LoginService loginService) {
		this.loginService = loginService;
	}

}
