package pantheon.web;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

import pantheon.ItemService;
import pantheon.PageService;
import pantheon.PeopleService;
import pantheon.model.ItemType;
import pantheon.model.Page;
import pantheon.model.PageType;
import pantheon.model.meta.Century;

public class CreatePageController extends PantheonSimpleFormController<PageCommand> {

	private PageService pageService;
	private PeopleService peopleService;
	private ItemService itemService;

	public CreatePageController() {
		super();
	}

	@Override
	protected ModelAndView showForm(HttpServletRequest request, HttpServletResponse response, BindException errors) throws Exception {
		if (errors.hasErrors()) {
			return super.showForm(request, response, errors);
		}

		// 人物の前リストを取得
		Map<String, Object> myModel = referenceData(request);

		PageCommand pageCommand = new PageCommand();
		myModel.put(COMMAND_NAME, pageCommand);

		return new ModelAndView(getFormView(), myModel);
	}

	@Override
	protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
		logger.info("UpdatePageController#onSubmit");

		PageCommand pageCommand = (PageCommand) command;

		// 名前重複チェック
		String inputName = pageCommand.getName();
		Page sameNamePage = pageService.findByName(inputName);
		if (sameNamePage != null) {
			errors.addError(createSameNameError("name", inputName));
			return showForm(request, response, errors);
		}

		PageType pageType = PageType.getByCode(Integer.parseInt(pageCommand.getPageTypeCode()));
		Page page = new Page(inputName, pageType, pageCommand.getFromCentury(), pageCommand.getToCentury());
		pageService.insert(page, pageCommand.getPeopleIds(), pageCommand.getNotClassificationItemIds());

		return new ModelAndView(new RedirectView(getSuccessView()));
	}

	@Override
	protected Map<String, Object> referenceData(HttpServletRequest request) throws Exception {
		Map<String, Object> myModel = new HashMap<String, Object>();

		myModel.put("peopleList", peopleService.findAll());
		myModel.put("notClassificationItemList", itemService.findAllItem(ItemType.NOT_CLASSIFICATION));
		myModel.put("centuryList", Century.getAllCenturyList());
		myModel.put("pageTypeArray", PageType.values());

		return myModel;
	}

	@Required
	public void setPageService(PageService pageService) {
		this.pageService = pageService;
	}

	@Required
	public void setPeopleService(PeopleService peopleService) {
		this.peopleService = peopleService;
	}

	@Required
	public void setItemService(ItemService itemService) {
		this.itemService = itemService;
	}
}
