package pantheon.user;

public enum UserType {
	ROLE_USER(0), // 一般ユーザ
	ROLE_ADMIN(1), // 管理者
	;

	private final int persistenceValue;

	public static UserType getByPersistenceValue(int persistenceValue) {
		for (UserType t : values()) {
			if (t.persistenceValue == persistenceValue) {
				return t;
			}
		}

		return null;
	}

	UserType(int persistenceValue) {
		this.persistenceValue = persistenceValue;
	}

	public int getPersistenceValue() {
		return persistenceValue;
	}

}
