package pantheon.model.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

//TODO enumにする
public class Century {

	private final static List<Century> centuries = new ArrayList<Century>();

	static {
//		centuries.add(new Century(-21, -2100, -2001));
//		centuries.add(new Century(-20, -2000, -1901));
//		centuries.add(new Century(-19, -1900, -1801));
//		centuries.add(new Century(-18, -1800, -1701));
//		centuries.add(new Century(-17, -1700, -1601));
//		centuries.add(new Century(-16, -1600, -1501));
//		centuries.add(new Century(-15, -1500, -1401));
//		centuries.add(new Century(-14, -1400, -1301));
//		centuries.add(new Century(-13, -1300, -1201));
//		centuries.add(new Century(-12, -1200, -1101));
//		centuries.add(new Century(-11, -1100, -1001));
//		centuries.add(new Century(-10, -1000, -901));
//		centuries.add(new Century(-9, -900, -801));
//		centuries.add(new Century(-8, -800, -701));
//		centuries.add(new Century(-7, -700, -601));
//		centuries.add(new Century(-6, -600, -501));
//		centuries.add(new Century(-5, -500, -401));
//		centuries.add(new Century(-4, -400, -301));
//		centuries.add(new Century(-3, -300, -201));
//		centuries.add(new Century(-2, -200, -101));
//		centuries.add(new Century(-1, -100, -001));
		centuries.add(new Century(1, 001, 100));
		centuries.add(new Century(2, 101, 200));
		centuries.add(new Century(3, 201, 300));
		centuries.add(new Century(4, 301, 400));
		centuries.add(new Century(5, 401, 500));
		centuries.add(new Century(6, 501, 600));
		centuries.add(new Century(7, 601, 700));
		centuries.add(new Century(8, 701, 800));
		centuries.add(new Century(9, 801, 900));
		centuries.add(new Century(10, 901, 1000));
		centuries.add(new Century(11, 1001, 1100));
		centuries.add(new Century(12, 1101, 1200));
		centuries.add(new Century(13, 1201, 1300));
		centuries.add(new Century(14, 1301, 1400));
		centuries.add(new Century(15, 1401, 1500));
		centuries.add(new Century(16, 1501, 1600));
		centuries.add(new Century(17, 1601, 1700));
		centuries.add(new Century(18, 1701, 1800));
		centuries.add(new Century(19, 1801, 1900));
		centuries.add(new Century(20, 1901, 2000));
		centuries.add(new Century(21, 2001, 2100));
	}

	public static Century getByIndex(int index) {
		for (Century century : centuries) {
			if (century.index == index) {
				return century;
			}
		}

		return null;
	}

	public static Century getByYear(int year) {
		for (Century century : centuries) {
			if (century.innerYear(year)) {
				return century;
			}
		}

		return null;
	}

	public static List<Century> getAllCenturyList() {
		return Collections.synchronizedList(centuries);
	}

	private int index;
	private int fromYear;
	private int toYear;
	private String name;

	public Century(int index, int fromYear, int toYear) {
		this.index = index;
		if (index < 0) {
			this.name = "前" + Math.abs(index) + "世紀";
		} else {
			this.name = index + "世紀";
		}

		this.fromYear = fromYear;
		this.toYear = toYear;
	}

	public int getIndex() {
		return index;
	}

	public int getFromYear() {
		return fromYear;
	}

	public int getToYear() {
		return toYear;
	}

	public String getName() {
		return name;
	}

	public boolean innerYear(int year) {
		return fromYear <= year && year <= toYear;
	}
}
