package pantheon.model;

import org.apache.commons.lang.StringUtils;

public enum PropertyType {

	POINT(1), //年
	PERIOD(2), //期間
	RELATION(3), //関係
	;

	public static PropertyType getByCode(String code) {
		if (code == null) {
			return null;
		}

		if (!StringUtils.isNumeric(code)) {
			return null;
		}

		return getByCode(Integer.parseInt(code));
	}

	public static PropertyType getByCode(int code) {
		for (PropertyType pageType : PropertyType.values()) {
			if (pageType.code == code) {
				return pageType;
			}
		}

		throw new IllegalArgumentException("unknown code. code=" + code);
	}

	private final int code;

	private PropertyType(int code) {
		this.code = code;

	}

	public int getCode() {
		return code;
	}

}
