package pantheon.model;

import java.util.ArrayList;
import java.util.List;

public class PageRecord extends AbstractPanteonModel {
	private Item item;
	private double startPosition;
	private double endPosition;
	private List<Item> subItemList;// TODO 今現在はBookのみを想定している
	private List<BookRecord> subList;// TODO 今現在はBookのみを想定している、各要素は
	private List<PropertyRecord> propertyRecordList;

	public PageRecord(Item item) {
		this.item = item;
	}

	public Item getItem() {
		return item;
	}

	public Item getPeople() {
		if (item.getType() != ItemType.PEOPLE) {
			throw new IllegalStateException("this item type is " + item.getType());
		}
		return item;
	}

	public double getStartPosition() {
		return startPosition;
	}

	void setStartPosition(double startPosition) {
		this.startPosition = startPosition;
	}

	public double getEndPosition() {
		return endPosition;
	}

	void setEndPosition(double endPosition) {
		this.endPosition = endPosition;
	}

	public List<Item> getSubItemList() {
		if (subItemList == null) {
			subItemList = new ArrayList<Item>();
		}
		return subItemList;
	}

	public void setSubItemList(List<Item> subItemList) {
		this.subItemList = subItemList;
	}

	public List<BookRecord> getSubList() {
		return subList;
	}

	public void setSubList(List<BookRecord> subList) {
		this.subList = subList;
	}

	public List<PropertyRecord> getPropertyRecordList() {
		return propertyRecordList;
	}

	public void setPropertyRecordList(List<PropertyRecord> propertyRecordList) {
		this.propertyRecordList = propertyRecordList;
	}

	public static class BookRecord {
		private Item item;
		private double startPosition;

		public BookRecord(Item item) {
			this.item = item;
		}

		public Item getItem() {
			return item;
		}

		public double getStartPosition() {
			return startPosition;
		}

		public void setStartPosition(double startPosition) {
			this.startPosition = startPosition;
		}
	}

	public static class PropertyRecord {
		private ItemProperty itemProperty;
		private double startPosition;

		public PropertyRecord(ItemProperty itemProperty) {
			this.itemProperty = itemProperty;
		}

		public ItemProperty getProperty() {
			return itemProperty;
		}

		public double getStartPosition() {
			return startPosition;
		}

		public void setStartPosition(double startPosition) {
			this.startPosition = startPosition;
		}
	}
}
