package pantheon.model;

import org.apache.commons.lang.StringUtils;

public enum Label {
	WRITTEN(1), // 著作物
	NOT_CLASSIFICATION(0), // その他
	;

	public static Label getByCode(String code) {
		if (code == null) {
			return null;
		}

		if (!StringUtils.isNumeric(code)) {
			return null;
		}

		return getByCode(Integer.parseInt(code));
	}

	public static Label getByCode(int code) {
		for (Label label : Label.values()) {
			if (label.code == code) {
				return label;
			}
		}

		throw new IllegalArgumentException("unknown code. code=" + code);
	}

	private final long code;

	private Label(long code) {
		this.code = code;
	}

	public long getCode() {
		return code;
	}

}
