package pantheon.model;

import org.apache.commons.lang.StringUtils;

public enum ItemType {

	PEOPLE(1, "人物", true, true), //
	BOOK(2, "書籍", true, false), //
	NOT_CLASSIFICATION(3, "未分類", "notClassification", false, false), //
	PICTURE(3, "絵画", true, false), //
	GOVERNMENT(4, "政権", true, true), //
	;

	public static ItemType getByCode(String code) {
		if (code == null) {
			return null;
		}

		if (!StringUtils.isNumeric(code)) {
			return null;
		}

		return getByCode(Integer.parseInt(code));
	}

	public static ItemType getByCode(int code) {
		for (ItemType pageType : ItemType.values()) {
			if (pageType.code == code) {
				return pageType;
			}
		}

		throw new IllegalArgumentException("unknown code. code=" + code);
	}

	private final int code;
	private final String name;// TODO enumのname()と混同するので別の属性名のほうがよかった
	private final String lowerName;
	private final boolean hasFromYear;
	private final boolean hasToYear;

	private ItemType(int code, String name, boolean hasFromYear, boolean hasToYear) {
		this(code, name, null, hasFromYear, hasToYear);
	}

	private ItemType(int code, String name, String lowerName, boolean hasFromYear, boolean hasToYear) {
		this.code = code;
		this.name = name;
		this.lowerName = lowerName == null ? name().toLowerCase() : lowerName;
		this.hasFromYear = hasFromYear;
		this.hasToYear = hasToYear;
	}

	public int getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public String getLowerName() {
		return lowerName;
	}

	//この舌足らずなメソッド名は、EL式で使用するため
	public boolean isHasFromYear() {
		return hasFromYear;
	}

	//この舌足らずなメソッド名は、EL式で使用するため
	public boolean isHasToYear() {
		return hasToYear;
	}

}
