package pantheon.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import pantheon.model.ItemType;
import pantheon.model.People;

public class PeopleJdbcHsqldbDao extends AbstractItemJdbcHsqldbDao implements PeopleDao {

	private final static String FIND_ALL = FIND_ALL_PREFIX + getType().getCode();

	private final static ItemType getType() {
		return ItemType.PEOPLE;
	}

	@Override
	public List<People> findAll() {
		List<People> list = getSimpleJdbcTemplate().query(FIND_ALL, new PeopleMapper());
		return list;
	}

	@Override
	public People findById(String peopleId) {

		List<People> list = getSimpleJdbcTemplate().query(FIND_BY_ID, new PeopleMapper(), peopleId);
		return getFirstRecordAfterCheck(list);
	}

	@Override
	public People findByName(String name) {
		List<People> list = getSimpleJdbcTemplate().query(FIND_BY_NAME, new PeopleMapper(), name);
		return getFirstRecordAfterCheck(list);
	}

	private static class PeopleMapper implements ParameterizedRowMapper<People> {
		public People mapRow(ResultSet rs, int rowNum) throws SQLException {
			People prod = new People();
			prod.setId(rs.getInt(FLD_ID));
			prod.setName(rs.getString("item_jp_name"));
			prod.setKanaName(rs.getString("item_jp_name_kana"));
			prod.setShortName(rs.getString("item_jp_name_short"));
			prod.setWikiName(rs.getString("item_wiki_name"));
			prod.setEnglishName(rs.getString("item_en_name"));
			prod.setFromYear(rs.getInt("fromYear"));
			prod.setToYear(rs.getInt("toYear"));
			prod.setVersion(rs.getInt("version"));
			prod.setUpdateUserId(rs.getInt("update_user_id"));
			prod.setUpdateDate(rs.getDate("update_date"));

			return prod;
		}
	}
}
