package pantheon.dao;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public abstract class PantheonJdbcDao extends SimpleJdbcDaoSupport {
	protected final Log logger = LogFactory.getLog(getClass());

	private final static String LAST_INSERT_ID = "SELECT LAST_INSERT_ID()";

	long getLastInsertId() {
		return getJdbcTemplate().queryForLong(LAST_INSERT_ID);
	}

	/**
	 * 1レコードのみ更新されたことをチェック
	 * 
	 * @param affectedCount
	 */
	void checkHitOneRecord(int affectedCount) {
		if (affectedCount == 0) {
			throw new IllegalStateException("更新失敗! count=0");
		} else if (affectedCount != 1) {
			throw new IllegalStateException("更新件数不正 count=" + affectedCount);
		}
	}
	
	<T> T getFirstRecordAfterCheck(List<T> list){
		if (list.size() == 0) {
			return null;
		}

		if (list.size() == 1) {
			return list.get(0);
		}

		throw new IllegalStateException();
	}

}
