package pantheon.dao;

import java.util.List;

import pantheon.model.Item;
import pantheon.model.Label;

public class ItemHistoryJdbcHsqldbDao extends AbstractItemJdbcHsqldbDao implements ItemHistoryDao {

	final static String FIND_BY_ID_WITH_VERSION;
	final static String FIND_ALL_ITEM_BY_ITEMTYPE;
	final static String FIND_ALL_TARGET_ITEM;

	static {
		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from item_hist ");
			sb.append("where item_id=? and version=?");
			FIND_BY_ID_WITH_VERSION = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from item_hist ");
			sb.append("where item_type=? ");
			sb.append("order by item_id ");
			FIND_ALL_ITEM_BY_ITEMTYPE = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			 sb.append("select * from item ");
			 sb.append("where item_id in (");
			 sb.append("select target_item_id from item_property_hist ");
			 sb.append("where item_id=? and label_id=? and item_version=?");
			 sb.append(")");

			FIND_ALL_TARGET_ITEM = sb.toString();
		}

	}

	@Override
	public void backup(long itemId, int version) {
		int affectedCount = getSimpleJdbcTemplate().update(BACKUP_ITEM, itemId, version);
		checkHitOneRecord(affectedCount);
	}

	@Override
	public Item findById(long itemId, int version) {
		List<Item> list = getSimpleJdbcTemplate().query(FIND_BY_ID_WITH_VERSION, new ItemMapper(), itemId, version);
		return getFirstRecordAfterCheck(list);
	}

	@Override
	public List<Item> findAllTargetItem(long itemId, Label label, int version) {
		return getSimpleJdbcTemplate().query(FIND_ALL_TARGET_ITEM, new ItemMapper(), itemId, label.getCode(), version);
	}
}
