package pantheon.dao;

import java.util.List;

import pantheon.model.Item;
import pantheon.model.ItemType;
import pantheon.model.Label;

public interface ItemDao {
	Item findById(long itemId);

	Item findByName(String name);

	Item findByIdForUpdate(long itemId);

	List<Item> findAllItem(ItemType itemType);

	List<Item> findAllTargetItem(long itemId, Label label);

	List<Item> findAllItemByTargetItem(Label label, long tagetId);

	List<Item> findAllHistory(long itemId);

	long insert(Item item, long userId);

	long insertSimple(Item item, long userId);

	int update(Item item, long userId);
	
	long updateSimple(Item item, long userId);
}
