package pantheon;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import pantheon.dao.ItemDao;
import pantheon.dao.PageDao;
import pantheon.model.Item;
import pantheon.model.Label;
import pantheon.model.Page;
import pantheon.model.PageRecord;

public class PageServiceImpl extends AbstractDefaultReadOnlyService implements PageService {
	private ItemDao itemDao;

	private PageDao pageDao;
	private ItemService itemService;

	@Override
	public List<Page> findAll() {
		return pageDao.findAll();
	}

	@Override
	public Page findById(int pageId) {
		Page page = pageDao.findById(pageId);

		// 人物情報を追加
		List<Item> peopleList = new ArrayList<Item>();
		if (StringUtils.isNotBlank(page.getJointPeopleIds())) {
			String[] array = page.getJointPeopleIds().split(",");
			for (String itemId : array) {
				Item item = itemService.findByIdWithProperties(Long.valueOf(itemId));
				peopleList.add(item);
			}
		}
		page.setPeopleList(peopleList);

		// 人物に紐づく書籍情報を追加
		// TODO ここn回のselect文
		for (PageRecord pageRecord : page.getRecordList()) {
			long itemId = pageRecord.getItem().getId();
			List<Item> bookList = itemDao.findAllTargetItem(itemId, Label.WRITTEN);
			pageRecord.setSubItemList(bookList);
		}
		page.calculateBookDataInAllPeopleRecords();

		// その他情報を追加
		List<Item> notClassificationList = new ArrayList<Item>();
		if (StringUtils.isNotBlank(page.getJointNotClassificationItemIds())) {
			String[] array = page.getJointNotClassificationItemIds().split(",");
			for (String itemId : array) {
				Item item = itemService.findByIdWithProperties(Long.valueOf(itemId));
				notClassificationList.add(item);
			}
		}
		page.setNotClassificationList(notClassificationList);
		page.calculatePointPropertyInAllItemRecords();

		return page;
	}

	@Override
	public Page findByName(String name) {
		return pageDao.findByName(name);
	}

	@Override
	@Transactional
	public void insert(Page page, Long[] peopleIds, Long[] notClassificationItemIds) {
		Assert.notNull(page);
		pageDao.insert(page, peopleIds, notClassificationItemIds);
	}

	@Override
	@Transactional
	public void update(Page page, Long[] peopleIds, Long[] notClassificationItemIds) {
		Assert.notNull(page);
		pageDao.update(page, peopleIds, notClassificationItemIds);
	}

	@Required
	public void setItemDao(ItemDao itemDao) {
		this.itemDao = itemDao;
	}

	@Required
	public void setPageDao(PageDao pageDao) {
		this.pageDao = pageDao;
	}

	@Required
	public void setItemService(ItemService itemService) {
		this.itemService = itemService;
	}

}
