package pantheon;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

import pantheon.dao.UserDao;
import pantheon.model.User;
import pantheon.user.UserType;

public class LoginServiceImpl extends AbstractDefaultReadOnlyService implements LoginService {

	private UserDao userDao;

	@Override
	public User findByUserId(long userId) {
		return userDao.findByUserId(userId);
	}

	@Override
	public User findByName(String name) {
		return userDao.findByUserName(name);
	}

	@Override
	@Transactional
	public void createUser(UserType type, String userName, String password, String note) {
		userDao.insert(type, userName, password, note);
	}

	@Override
	@Transactional
	public void updateUser(long userId, String userName, String note) {
		userDao.update(userId, userName, note);
	}

	@Required
	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

}
