<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

function xmldb_local_ties_install() {
    global $DB;
    global $CFG;
    require($CFG->dirroot.'/local/ties/version.php');
    require_once($CFG->dirroot.'/local/ties/lib.php');

    // 配布サイトのURLをコンフィグに登録
    $config = new stdClass();
    $config->name = 'downloadurl';
    $config->value = 'http://download.cccties.org/';

    // configの設定が既に登録していないかチェック
    $downloadurl = $DB->get_records_select('config','name=?',array($config->name));
    if(count($downloadurl) > 0){
        $DB->delete_records("config", array("name" => $config->name));
    }

    $DB->insert_record('config', $config);

    // モジュールのバックアップ期間を設定
    $config = new stdClass();
    $config->name = 'backup_period';
    $config->value = '30';

    // configの設定が既に登録していないかチェック
    $period = $DB->get_records_select('config','name=?',array($config->name));
    if(count($period) > 0){
        $DB->delete_records("config", array("name" => $config->name));
    }

    $DB->insert_record('config', $config);

    // インストールが完了したら、データを登録する
    // ToDo:モジュール名をconfigからとるか検討（ただしモジュール名がmodなど先頭についてしまう）
    $version = '';
    if(!empty($module->version)){
        $version = $module->version;
    }else if(!empty($plugin->version)){
        $version = $plugin->version;
    }

    $dispversion = '';
    if(!empty($module->dispversion)){
        $dispversion = $module->dispversion;
    }else if(!empty($plugin->dispversion)){
        $dispversion = $plugin->dispversion;
    }

    $module_info           = new stdClass();
    $module_info->name     = "ties";
    $module_info->version  = $version;
    $module_info->dispversion  = $dispversion;
    $DB->insert_record('local_ties_modules', $module_info);

    // tiesモジュール管理対象のモジュールを自動追加
    $manage_modules = check_modules();
    if(count($manage_modules) > 0){
        foreach($manage_modules as $module){
            manage_module($module['name'], $module['path']);
        }
    }

    if(file_exists(dirname(__FILE__) . '/../../../theme/ties/')) {
        $theme = $DB->get_records_select('config','name=?',array('theme'));
        if(!empty($theme)){
            $theme = reset($theme);
            $theme->value = 'ties';
            $DB->update_record('config', $theme);
        }
    }

    if(!empty($module->tiesversion)){
        $version = $module->tiesversion;
    }else if(!empty($plugin->tiesversion)){
        $version = $plugin->tiesversion;
    }

    if(!empty($module->tiesdispversion)){
        $dispversion = $module->tiesdispversion;
    }else if(!empty($plugin->tiesdispversion)){
        $dispversion = $plugin->tiesdispversion;
    }

    $module_info           = new stdClass();
    $module_info->name     = "TIES v8";
    $module_info->version  = $version;
    $module_info->dispversion  = $dispversion;
    $DB->insert_record('local_ties_modules', $module_info);

}
