#! /usr/local/bin/ruby -Ks
# testcaseconv
# Testcase auto Converter(TestLink) CSV<=>XML 
# 
# 2007/11/27 0.00 garyo new release

require 'csv'
require 'kconv'
require 'vr/vruby'
require '_frm_testcaseConv.rb'
require 'rexml/document'

class TestCase
  attr_accessor :name,:summary,:steps,:expectedresults,:keyword
  def initialize(name,summary,steps,expectedresults,keyword)
    @name=Kconv.toutf8(name)
    @summary=Kconv.toutf8(summary)
    @steps=Kconv.toutf8(steps)
    @expectedresults=Kconv.toutf8(expectedresults)
    @keyword = keyword.map!{|x|Kconv.toutf8(x)}
  end

  def getXML
    @xml =  "<testcase name=\"#{name}\">"
    @xml += "<summary><![CDATA[\n#{summary}\n]]></summary>"
    @xml += "<steps><![CDATA[\n#{steps}\n]]></steps>"
    @xml += "<expectedresults><![CDATA[\n#{expectedresults}\n]]></expectedresults>\n"
		@xml += convKeyword(@keyword) if @keyword.size > 0
    @xml += "</testcase>\n"
    @xml
  end

  def getCSV
    @csv =  "#{name},#{summary},#{steps},#{expectedresults}"
		@csv += "," + @keyword.join(",") if @keyword.size > 0
    (@csv+"\n").tosjis
  end

  def convKeyword(k)
    ret ="<keywords>\n"
    n = k.size/2
    n.times{|i|
      if k[i * 2] != nil then
        k[i * 2 + 1] ="" if k[i * 2 + 1] == nil
        ret += "<keyword name=\"#{k[i * 2]}\">\n"
        ret += "<notes><![CDATA[\n#{k[i * 2 + 1]}\n]]></notes>\n"
        ret += "</keyword>\n"
      end
    }
    ret += "</keywords>\n"
  end
end

class TestSuite
  attr_accessor :name,:details,:testcase,:testsuite
  @name
  @details
  @testcase
  @testsuite
  @xml
  def initialize(name,details)
    @name=Kconv.toutf8(name)
    @details=Kconv.toutf8(details)
    @testcase=[]
    @testsuite=[]
  end
  
  def addTestCase(t)
    @testcase << t
  end
  
  def addTestSuite(t)
    @testsuite << t
  end
  
  def getXML
    @xml="<testsuite name=\"#{@name}\"><details><![CDATA[\n#{@details}\n]]></details>\n"
    @testcase.each{|s| @xml += s.getXML}
    @testsuite.each{|s| @xml += s.getXML}
    @xml += "</testsuite>\n"
    @xml
  end

  def getCSV
    @csv = ""
    @testcase.each{|s| @csv +=  "#{@name.tosjis}," + s.getCSV}
    @csv
  end

end

class AllTestSuite
  attr_accessor :testsuite,:useTitleLine

  TestSuiteName = 0
  Name = 1
  Summary = 2
  Steps = 3
  Expectedresults = 4
  Keyword = 5

  def initialize
    @testsuite=[]
  end

  def serchTestsuite(name)
    @testsuite.each{|x|
      if x.name == name.toutf8 then
        return x
      end
    }
    ts = TestSuite.new(name,"")
    @testsuite << ts
    return ts
  end

  def addTestcase(testSuiteName,name,summary,steps,expectedresults,keyword)
    ts = serchTestsuite(testSuiteName)
    s=TestCase.new(name,summary,steps,expectedresults,keyword)
    ts.addTestCase(s)
  end

  def readCSVFile(file)
    open(file, 'r'){|f|
      i = 0
      while l=f.gets
        line = l.split(",")
        line.each{|d|d = "" if d == nil}
  			if i == 0 and @useTitleLine == true then
	  			#skip title line
		  	else
			  	addTestcase(line[TestSuiteName],line[Name],line[Summary],line[Steps],line[Expectedresults],line[Keyword..-1])
			  end
      end
    }
  end

  def readXMLFile(f)
    file = File.new f
    @doc = REXML::Document.new file
    xmltestsuite2array(@doc.root)
  end

  def readFile(file)
    case File.extname(file).downcase
    when ".xml"
      readXMLFile(file)
    when ".csv"
      readCSVFile(file)
    else
      puts "file #{file} error#{File.extname(file).downcase}"
    end
  end

  def writeFile(file)
    case File.extname(file).downcase
    when ".xml"
      saveXMLFile(file)
    when ".csv"
      saveCSVFile(file)
    else
      puts "file #{file} error#{File.extname(file).downcase}"
    end
  end

  def saveCSVFile(file)
    open(file,"w"){|f|
      f.puts getCSV
    }
  end

  def saveXMLFile(file)
    open(file,"w"){|f|
      f.puts getXML
    }
  end

  def getXmltestsuiteName(elem)
    if elem.name=="testsuite" then
      elem.attributes["name"].to_s.tosjis
    else
      nil
    end
  end
  
  def xmltestsuite2array(elem)
    testsuitename = getXmltestsuiteName(elem)
    if testsuitename then
      elem.each_element{|e|
        if e.name == "testcase" then
          name =  e.attributes["name"]
          summary =  e.elements["summary"].text
          steps =  e.elements["steps"].text
          expectedresults = e.elements["expectedresults"].text
          r=[]
          if e.elements["keywords"] then
            e.elements["keywords"].each_element{|ky|
              r << ky.attributes["name"]
              r << ky.elements["notes"].text
            }
          end
          keyword = r
          keyword.map!{|x| x.tosjis}
          keyword.map!{|x| x.gsub!(/\n/,"");x}
          testsuitename.gsub!(/\n/,"")
          name.gsub!(/\n/,"")
          summary.gsub!(/\n/,"")
          steps.gsub!(/\n/,"")
          expectedresults.gsub!(/\n/,"")
          addTestcase(testsuitename,name,summary,steps,expectedresults,keyword)
        end
      }
    end
    elem.each_element{|e|
      xmltestsuite2array(e)
    }
  end

  def getXML
    @xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
    @xml += "<testsuite name=\"\"><details><![CDATA[\n\n]]></details>\n" if @testsuite.size > 0
    @testsuite.each{|ts|
      @xml=@xml + ts.getXML
    }
    @xml += "</testsuite>\n" if @testsuite.size > 0
    @xml
  end

  def getCSV
    csv = ""
    @testsuite.each{|ts|
      csv += ts.getCSV
    }
    csv
  end
end

module Frm_form1
  def self_created
    
  end
  def open_clicked
  	file=openFilenameDialog([["all(*.*)", "*.*"]],0x1000,nil,nil)
    main(file)
  end

  def exit_clicked
  	exit(0)
  end

  def doConvert_clicked
  	button2_clicked
  end

  def main(file)
  	if file =="" then
			messageBox "Filename error","MSGBOX",0
		else
			ats=AllTestSuite.new
			if @checkBox1.checked? == true then
				ats.useTitleLine = true
			else
				ats.useTitleLine = false
			end
      ats.readFile(file)
      
      case File.extname(file).downcase
      when ".xml"
        extname = ".csv"
      when ".csv"
        extname = ".xml"
      else
        puts "file #{file} error#{File.extname(file).downcase}"
      end

			wrfile = File.dirname(file) + "/" + File.basename(file, ".*") + extname
      ats.writeFile(wrfile)
			messageBox "finish #{wrfile}","MSGBOX",0
		end
  end
end

VRLocalScreen.start Frm_form1

#ats=AllTestSuite.new
#ats.readXMLFile("test.xml")
#puts ats.getCSV
#ats.saveCSVFile("test.csv")
#ats.readCSVFile("test3.csv")
#ats.saveXMLFile("test3.xml")

#ats.readFile("testsuites_test2.xml")
#ats.writeFile("testsuites_test22.csv")

#ats.readFile("testsuites_test22.csv")
#ats.writeFile("testsuites_test32.xml")
