/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.SecureClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.bnf.Bnf;
import org.h2.engine.Constants;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.tools.Backup;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.ConvertTraceFile;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ByteUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.NetUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

class WebThread
extends Thread
implements DatabaseEventListener {
    WebSession session;
    OutputStream output;
    String mimeType;
    long listenerLastEvent;
    int listenerLastState;
    Socket socket;
    WebServer server;
    private Properties attributes;
    private InputStream input;
    private String ifModifiedSince;
    private boolean cache;
    private boolean stop;
    private String headerLanguage;
    static /* synthetic */ Class class$org$h2$server$web$WebThread$DynamicClassLoader;
    static /* synthetic */ Class array$Ljava$lang$String;

    WebThread(Socket socket, WebServer webServer) {
        this.server = webServer;
        this.socket = socket;
        this.setName("H2 Console thread");
    }

    void setSession(WebSession webSession, Properties properties) {
        this.session = webSession;
        this.attributes = properties;
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String string) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (string.length() == 0) {
            return "index.do";
        }
        return string;
    }

    String processRequest(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = n >= 0 ? string.substring(n + 1) : "";
        if ("ico".equals(string3)) {
            this.mimeType = "image/x-icon";
            this.cache = true;
        } else if ("gif".equals(string3)) {
            this.mimeType = "image/gif";
            this.cache = true;
        } else if ("css".equals(string3)) {
            this.cache = true;
            this.mimeType = "text/css";
        } else if ("html".equals(string3) || "do".equals(string3) || "jsp".equals(string3)) {
            this.cache = false;
            this.mimeType = "text/html";
            if (this.session == null) {
                this.session = this.server.createNewSession(string2);
                if (!"notAllowed.jsp".equals(string)) {
                    string = "index.do";
                }
            }
        } else if ("js".equals(string3)) {
            this.cache = true;
            this.mimeType = "text/javascript";
        } else {
            this.cache = false;
            this.mimeType = "text/html";
            string = "error.jsp";
            this.trace("Unknown mime type, file " + string);
        }
        this.trace("mimeType=" + this.mimeType);
        this.trace(string);
        if (string.endsWith(".do")) {
            string = this.process(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop && this.process()) {
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException, SQLException {
        boolean bl = false;
        String string = this.readHeaderLine();
        if (string.startsWith("GET ") || string.startsWith("POST ")) {
            byte[] byArray;
            String string2;
            String string3;
            int n = string.indexOf(47);
            int n2 = string.lastIndexOf(32);
            String string4 = n < 0 || n2 < n ? "" : string.substring(n + 1, n2).trim();
            this.trace(string + ": " + string4);
            string4 = this.getAllowedFile(string4);
            this.attributes = new Properties();
            int n3 = string4.indexOf("?");
            this.session = null;
            if (n3 >= 0) {
                string3 = string4.substring(n3 + 1);
                this.parseAttributes(string3);
                string2 = this.attributes.getProperty("jsessionid");
                string4 = string4.substring(0, n3);
                this.session = this.server.getSession(string2);
            }
            bl = this.parseHeader();
            string3 = this.socket.getInetAddress().getHostAddress();
            if ((string4 = this.processRequest(string4, string3)).length() == 0) {
                return true;
            }
            if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                byArray = null;
                string2 = "HTTP/1.1 304 Not Modified\n";
            } else {
                byArray = this.server.getFile(string4);
                if (byArray == null) {
                    string2 = "HTTP/1.0 404 Not Found\n";
                    byArray = StringUtils.utf8Encode("File not found: " + string4);
                } else {
                    if (this.session != null && string4.endsWith(".jsp")) {
                        String string5 = StringUtils.utf8Decode(byArray);
                        string5 = PageParser.parse(string5, this.session.map);
                        try {
                            byArray = StringUtils.utf8Encode(string5);
                        }
                        catch (SQLException sQLException) {
                            this.server.traceError(sQLException);
                        }
                    }
                    string2 = "HTTP/1.1 200 OK\n";
                    string2 = string2 + "Content-Type: " + this.mimeType + "\n";
                    if (!this.cache) {
                        string2 = string2 + "Cache-Control: no-cache\n";
                    } else {
                        string2 = string2 + "Cache-Control: max-age=10\n";
                        string2 = string2 + "Last-Modified: " + this.server.getStartDateTime() + "\n";
                    }
                    string2 = string2 + "Content-Length: " + byArray.length + "\n";
                }
            }
            string2 = string2 + "\n";
            this.trace(string2);
            this.output.write(string2.getBytes());
            if (byArray != null) {
                this.output.write(byArray);
            }
            this.output.flush();
        }
        return bl;
    }

    private String getComboBox(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            stringBuffer.append("<option value=\"");
            stringBuffer.append(PageParser.escapeHtmlData(string2));
            stringBuffer.append("\"");
            if (string2.equals(string)) {
                stringBuffer.append(" selected");
            }
            stringBuffer.append(">");
            stringBuffer.append(PageParser.escapeHtml(string2));
            stringBuffer.append("</option>");
        }
        return stringBuffer.toString();
    }

    private String getComboBox(String[][] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            stringBuffer.append("<option value=\"");
            stringBuffer.append(PageParser.escapeHtmlData(stringArray2[0]));
            stringBuffer.append("\"");
            if (stringArray2[0].equals(string)) {
                stringBuffer.append(" selected");
            }
            stringBuffer.append(">");
            stringBuffer.append(PageParser.escapeHtml(stringArray2[1]));
            stringBuffer.append("</option>");
        }
        return stringBuffer.toString();
    }

    private String readHeaderLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 13 && this.input.read() == 10) {
                return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
            }
            stringBuffer.append((char)n);
        }
    }

    private void parseAttributes(String string) {
        int n;
        this.trace("data=" + string);
        while (string != null && (n = string.indexOf(61)) >= 0) {
            String string2;
            String string3 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(38)) >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
            }
            String string4 = StringUtils.urlDecode(string2);
            this.attributes.put(string3, string4);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        Object object;
        boolean bl = false;
        this.trace("parseHeader");
        int n = 0;
        this.ifModifiedSince = null;
        block0: while ((object = this.readHeaderLine()) != null) {
            Object object2;
            this.trace(" " + (String)object);
            String string = StringUtils.toLowerEnglish((String)object);
            if (string.startsWith("if-modified-since")) {
                this.ifModifiedSince = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                continue;
            }
            if (string.startsWith("connection")) {
                object2 = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                if (!"keep-alive".equals(object2)) continue;
                bl = true;
                continue;
            }
            if (string.startsWith("content-length")) {
                n = Integer.parseInt(((String)object).substring(((String)object).indexOf(58) + 1).trim());
                this.trace("len=" + n);
                continue;
            }
            if (string.startsWith("accept-language")) {
                object2 = this.session == null ? null : this.session.locale;
                if (object2 != null) continue;
                String string2 = ((String)object).substring(((String)object).indexOf(58) + 1).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("q=") || !this.server.supportsLanguage(string3)) continue;
                    int n2 = string3.indexOf(45);
                    if (n2 >= 0) {
                        String string4 = string3.substring(0, n2);
                        String string5 = string3.substring(n2 + 1);
                        object2 = new Locale(string4, string5);
                    } else {
                        object2 = new Locale(string3, "");
                    }
                    this.headerLanguage = ((Locale)object2).getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = object2;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (((String)object).trim().length() != 0) continue;
        }
        if (this.session != null && n > 0) {
            object = ByteUtils.newBytes(n);
            for (int i = 0; i < n; i += this.input.read((byte[])object, i, n - i)) {
            }
            String string = new String((byte[])object);
            this.parseAttributes(string);
        }
        return bl;
    }

    private String process(String string) {
        this.trace("process " + string);
        while (string.endsWith(".do")) {
            if ("login.do".equals(string)) {
                string = this.login();
                continue;
            }
            if ("index.do".equals(string)) {
                string = this.index();
                continue;
            }
            if ("logout.do".equals(string)) {
                string = this.logout();
                continue;
            }
            if ("settingRemove.do".equals(string)) {
                string = this.settingRemove();
                continue;
            }
            if ("settingSave.do".equals(string)) {
                string = this.settingSave();
                continue;
            }
            if ("test.do".equals(string)) {
                string = this.test();
                continue;
            }
            if ("query.do".equals(string)) {
                string = this.query();
                continue;
            }
            if ("tables.do".equals(string)) {
                string = this.tables();
                continue;
            }
            if ("editResult.do".equals(string)) {
                string = this.editResult();
                continue;
            }
            if ("getHistory.do".equals(string)) {
                string = this.getHistory();
                continue;
            }
            if ("admin.do".equals(string)) {
                string = this.admin();
                continue;
            }
            if ("adminSave.do".equals(string)) {
                string = this.adminSave();
                continue;
            }
            if ("adminShutdown.do".equals(string)) {
                string = this.adminShutdown();
                continue;
            }
            if ("autoCompleteList.do".equals(string)) {
                string = this.autoCompleteList();
                continue;
            }
            if ("tools.do".equals(string)) {
                string = this.tools();
                continue;
            }
            string = "error.jsp";
        }
        this.trace("return " + string);
        return string;
    }

    private String autoCompleteList() {
        String string = (String)this.attributes.get("query");
        boolean bl = false;
        if (string.trim().length() > 0 && Character.isLowerCase(string.trim().charAt(0))) {
            bl = true;
        }
        try {
            String string2;
            String string3 = string;
            if (string3.endsWith(";")) {
                string3 = string3 + " ";
            }
            ScriptReader scriptReader = new ScriptReader(new StringReader(string3));
            scriptReader.setSkipRemarks(true);
            String string4 = "";
            while ((string2 = scriptReader.readStatement()) != null) {
                string4 = string2;
            }
            string2 = "";
            if (scriptReader.isInsideRemark()) {
                string2 = scriptReader.isBlockRemark() ? "1#(End Remark)# */\n" + string2 : "1#(Newline)#\n" + string2;
            } else {
                Object object;
                char c;
                Bnf bnf;
                string3 = string4;
                while (string3.length() > 0 && string3.charAt(0) <= ' ') {
                    string3 = string3.substring(1);
                }
                if (string3.trim().length() > 0 && Character.isLowerCase(string3.trim().charAt(0))) {
                    bl = true;
                }
                if ((bnf = this.session.getBnf()) == null) {
                    return "autoCompleteList.jsp";
                }
                HashMap hashMap = bnf.getNextTokenList(string3);
                String string5 = "";
                if (string3.length() > 0 && !Character.isWhitespace(c = string3.charAt(string3.length() - 1)) && c != '.' && c >= ' ' && c != '\'' && c != '\"') {
                    string5 = " ";
                }
                ArrayList<String> arrayList = new ArrayList<String>(hashMap.size());
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    String string6 = (String)object.getKey();
                    String string7 = "" + string6.charAt(0);
                    String string8 = (String)object.getValue();
                    if (Character.isLetter((string6 = string6.substring(2)).charAt(0)) && bl) {
                        string6 = StringUtils.toLowerEnglish(string6);
                        string8 = StringUtils.toLowerEnglish(string8);
                    }
                    if (string6.equals(string8) && !".".equals(string8)) {
                        string8 = string5 + string8;
                    }
                    string6 = StringUtils.urlEncode(string6);
                    string6 = StringUtils.replaceAll(string6, "+", " ");
                    string8 = StringUtils.urlEncode(string8);
                    string8 = StringUtils.replaceAll(string8, "+", " ");
                    arrayList.add(string7 + "#" + string6 + "#" + string8);
                }
                Collections.sort(arrayList);
                object = new StringBuffer();
                if (string.endsWith("\n") || string.trim().endsWith(";")) {
                    arrayList.add(0, "1#(Newline)#\n");
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i > 0) {
                        ((StringBuffer)object).append('|');
                    }
                    ((StringBuffer)object).append((String)arrayList.get(i));
                }
                string2 = ((StringBuffer)object).toString();
            }
            this.session.put("autoCompleteList", string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return "autoCompleteList.jsp";
    }

    private String admin() {
        this.session.put("port", "" + this.server.getPort());
        this.session.put("allowOthers", "" + this.server.getAllowOthers());
        this.session.put("ssl", String.valueOf(this.server.getSSL()));
        this.session.put("sessions", this.server.getSessions());
        return "admin.jsp";
    }

    private String adminSave() {
        try {
            this.server.setPort(MathUtils.decodeInt((String)this.attributes.get("port")));
            this.server.setAllowOthers(Boolean.valueOf((String)this.attributes.get("allowOthers")));
            this.server.setSSL(Boolean.valueOf((String)this.attributes.get("ssl")));
            this.server.saveSettings();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
        return this.admin();
    }

    private String tools() {
        try {
            String string = (String)this.attributes.get("tool");
            this.session.put("tool", string);
            String string2 = (String)this.attributes.get("args");
            String[] stringArray = StringUtils.arraySplit(string2, ',', false);
            Tool tool = null;
            if ("Backup".equals(string)) {
                tool = new Backup();
            } else if ("Restore".equals(string)) {
                tool = new Restore();
            } else if ("Recover".equals(string)) {
                tool = new Recover();
            } else if ("DeleteDbFiles".equals(string)) {
                tool = new DeleteDbFiles();
            } else if ("ChangeFileEncryption".equals(string)) {
                tool = new ChangeFileEncryption();
            } else if ("Script".equals(string)) {
                tool = new Script();
            } else if ("RunScript".equals(string)) {
                tool = new RunScript();
            } else if ("ConvertTraceFile".equals(string)) {
                tool = new ConvertTraceFile();
            } else if ("CreateCluster".equals(string)) {
                tool = new CreateCluster();
            } else {
                throw Message.getInternalError(string);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, "UTF-8");
            tool.setOut(printStream);
            try {
                tool.run(stringArray);
                printStream.flush();
                String string3 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                String string4 = PageParser.escapeHtml(string3);
                this.session.put("toolResult", string4);
            }
            catch (Exception exception) {
                this.session.put("toolResult", this.getStackTrace(0, exception, true));
            }
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        return "tools.jsp";
    }

    private String adminShutdown() {
        this.stopNow();
        this.server.shutdown();
        return "admin.jsp";
    }

    private String index() {
        String[][] stringArray = this.server.getLanguageArray();
        String string = (String)this.attributes.get("language");
        if (string == null) {
            string = this.headerLanguage;
        }
        Locale locale = this.session.locale;
        if (string != null) {
            if (locale == null || !StringUtils.toLowerEnglish(locale.getLanguage()).equals(string)) {
                locale = new Locale(string, "");
                this.server.readTranslations(this.session, locale.getLanguage());
                this.session.put("language", string);
                this.session.locale = locale;
            }
        } else {
            string = (String)this.session.get("language");
        }
        this.session.put("languageCombo", this.getComboBox(stringArray, string));
        String[] stringArray2 = this.server.getSettingNames();
        String string2 = this.attributes.getProperty("setting");
        if (string2 == null && stringArray2.length > 0) {
            string2 = stringArray2[0];
        }
        String string3 = this.getComboBox(stringArray2, string2);
        this.session.put("settingsList", string3);
        ConnectionInfo connectionInfo = this.server.getSetting(string2);
        if (connectionInfo == null) {
            connectionInfo = new ConnectionInfo();
        }
        this.session.put("setting", PageParser.escapeHtmlData(string2));
        this.session.put("name", PageParser.escapeHtmlData(string2));
        this.session.put("driver", PageParser.escapeHtmlData(connectionInfo.driver));
        this.session.put("url", PageParser.escapeHtmlData(connectionInfo.url));
        this.session.put("user", PageParser.escapeHtmlData(connectionInfo.user));
        return "index.jsp";
    }

    private String getHistory() {
        int n = Integer.parseInt(this.attributes.getProperty("id"));
        String string = this.session.getCommand(n);
        this.session.put("query", PageParser.escapeHtmlData(string));
        return "query.jsp";
    }

    private int addColumns(DbTableOrView dbTableOrView, StringBuffer stringBuffer, int n, boolean bl, StringBuffer stringBuffer2) {
        DbColumn[] dbColumnArray = dbTableOrView.columns;
        for (int i = 0; dbColumnArray != null && i < dbColumnArray.length; ++i) {
            DbColumn dbColumn = dbColumnArray[i];
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(' ');
            }
            stringBuffer2.append(dbColumn.name);
            String string = StringUtils.urlEncode(PageParser.escapeJavaScript(dbColumn.name));
            stringBuffer.append("setNode(" + n + ", 1, 1, 'column', '" + PageParser.escapeJavaScript(dbColumn.name) + "', 'javascript:ins(\\'" + string + "\\')');\n");
            ++n;
            if (!bl) continue;
            stringBuffer.append("setNode(" + n + ", 2, 2, 'type', '" + PageParser.escapeJavaScript(dbColumn.dataType) + "', null);\n");
            ++n;
        }
        return n;
    }

    private int addIndexes(DatabaseMetaData databaseMetaData, String string, String string2, StringBuffer stringBuffer, int n) throws SQLException {
        IndexInfo indexInfo;
        Object object;
        ResultSet resultSet = databaseMetaData.getIndexInfo(null, string2, string, false, true);
        HashMap<Object, IndexInfo> hashMap = new HashMap<Object, IndexInfo>();
        while (resultSet.next()) {
            object = resultSet.getString("INDEX_NAME");
            indexInfo = (IndexInfo)hashMap.get(object);
            if (indexInfo == null) {
                int n2 = resultSet.getInt("TYPE");
                String string3 = n2 == 1 ? "" : (n2 == 2 ? " (${text.tree.hashed})" : (n2 == 3 ? "" : null));
                if (object == null || string3 == null) continue;
                indexInfo = new IndexInfo();
                indexInfo.name = object;
                indexInfo.type = string3 = (resultSet.getBoolean("NON_UNIQUE") ? "${text.tree.nonUnique}" : "${text.tree.unique}") + string3;
                indexInfo.columns = resultSet.getString("COLUMN_NAME");
                hashMap.put(object, indexInfo);
                continue;
            }
            indexInfo.columns = indexInfo.columns + ", " + resultSet.getString("COLUMN_NAME");
        }
        resultSet.close();
        if (hashMap.size() > 0) {
            stringBuffer.append("setNode(" + n + ", 1, 1, 'index_az', '${text.tree.indexes}', null);\n");
            ++n;
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                indexInfo = (IndexInfo)object.next();
                stringBuffer.append("setNode(" + n + ", 2, 1, 'index', '" + PageParser.escapeJavaScript(indexInfo.name) + "', null);\n");
                stringBuffer.append("setNode(" + ++n + ", 3, 2, 'type', '" + indexInfo.type + "', null);\n");
                stringBuffer.append("setNode(" + ++n + ", 3, 2, 'type', '" + PageParser.escapeJavaScript(indexInfo.columns) + "', null);\n");
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addTablesAndViews(DbSchema dbSchema, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        StringBuffer stringBuffer2;
        String string;
        int n2;
        DbTableOrView dbTableOrView;
        int n3;
        if (dbSchema == null) {
            return n;
        }
        Connection connection = this.session.getConnection();
        DatabaseMetaData databaseMetaData = this.session.getMetaData();
        int n4 = bl ? 0 : 1;
        String string2 = ", " + n4 + ", " + (n4 + 1) + ", ";
        String string3 = ", " + (n4 + 1) + ", " + (n4 + 1) + ", ";
        DbTableOrView[] dbTableOrViewArray = dbSchema.tables;
        if (dbTableOrViewArray == null) {
            return n;
        }
        boolean bl2 = dbSchema.contents.isOracle;
        boolean bl3 = dbTableOrViewArray.length < 100;
        for (n3 = 0; n3 < dbTableOrViewArray.length; ++n3) {
            dbTableOrView = dbTableOrViewArray[n3];
            if (dbTableOrView.isView) continue;
            n2 = n;
            string = dbTableOrView.quotedName;
            if (!bl) {
                string = dbSchema.quotedName + "." + string;
            }
            string = StringUtils.urlEncode(PageParser.escapeJavaScript(string));
            stringBuffer.append("setNode(" + n + string2 + " 'table', '" + PageParser.escapeJavaScript(dbTableOrView.name) + "', 'javascript:ins(\\'" + string + "\\',true)');\n");
            ++n;
            if (!bl) continue;
            stringBuffer2 = new StringBuffer();
            n = this.addColumns(dbTableOrView, stringBuffer, n, bl3, stringBuffer2);
            if (!bl2 && bl3) {
                n = this.addIndexes(databaseMetaData, dbTableOrView.name, dbSchema.name, stringBuffer, n);
            }
            stringBuffer.append("addTable('" + PageParser.escapeJavaScript(dbTableOrView.name) + "', '" + PageParser.escapeJavaScript(stringBuffer2.toString()) + "', " + n2 + ");\n");
        }
        dbTableOrViewArray = dbSchema.tables;
        for (n3 = 0; n3 < dbTableOrViewArray.length; ++n3) {
            dbTableOrView = dbTableOrViewArray[n3];
            if (!dbTableOrView.isView) continue;
            n2 = n;
            string = dbTableOrView.quotedName;
            if (!bl) {
                string = dbTableOrView.schema.quotedName + "." + string;
            }
            string = StringUtils.urlEncode(PageParser.escapeJavaScript(string));
            stringBuffer.append("setNode(" + n + string2 + " 'view', '" + PageParser.escapeJavaScript(dbTableOrView.name) + "', 'javascript:ins(\\'" + string + "\\',true)');\n");
            ++n;
            if (!bl) continue;
            stringBuffer2 = new StringBuffer();
            n = this.addColumns(dbTableOrView, stringBuffer, n, bl3, stringBuffer2);
            if (dbSchema.contents.isH2) {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=?");
                    preparedStatement.setString(1, dbTableOrView.name);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString("SQL");
                        stringBuffer.append("setNode(" + n + string3 + " 'type', '" + PageParser.escapeJavaScript(string4) + "', null);\n");
                        ++n;
                    }
                    resultSet.close();
                }
                finally {
                    JdbcUtils.closeSilently(preparedStatement);
                }
            }
            stringBuffer.append("addTable('" + PageParser.escapeJavaScript(dbTableOrView.name) + "', '" + PageParser.escapeJavaScript(stringBuffer2.toString()) + "', " + n2 + ");\n");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tables() {
        DbContents dbContents = this.session.getContents();
        boolean bl = false;
        try {
            Object object;
            dbContents.readContents(this.session.getMetaData());
            this.session.loadBnf();
            Connection connection = this.session.getConnection();
            DatabaseMetaData databaseMetaData = this.session.getMetaData();
            bl = dbContents.isH2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("setNode(0, 0, 0, 'database', '" + PageParser.escapeJavaScript((String)this.session.get("url")) + "', null);\n");
            int n = 1;
            DbSchema dbSchema = dbContents.defaultSchema;
            n = this.addTablesAndViews(dbSchema, true, stringBuffer, n);
            DbSchema[] dbSchemaArray = dbContents.schemas;
            for (int i = 0; i < dbSchemaArray.length; ++i) {
                object = dbSchemaArray[i];
                if (object == dbSchema || object == null) continue;
                stringBuffer.append("setNode(" + n + ", 0, 1, 'folder', '" + PageParser.escapeJavaScript(((DbSchema)object).name) + "', null);\n");
                ++n;
                n = this.addTablesAndViews((DbSchema)object, false, stringBuffer, n);
            }
            if (bl) {
                Statement statement = null;
                try {
                    String string;
                    String string2;
                    statement = connection.createStatement();
                    object = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    int n2 = 0;
                    while (object.next()) {
                        if (n2 == 0) {
                            stringBuffer.append("setNode(" + n + ", 0, 1, 'sequences', '${text.tree.sequences}', null);\n");
                            ++n;
                        }
                        string2 = object.getString("SEQUENCE_NAME");
                        string = object.getString("CURRENT_VALUE");
                        String string3 = object.getString("INCREMENT");
                        stringBuffer.append("setNode(" + n + ", 1, 1, 'sequence', '" + PageParser.escapeJavaScript(string2) + "', null);\n");
                        stringBuffer.append("setNode(" + ++n + ", 2, 2, 'type', '${text.tree.current}: " + PageParser.escapeJavaScript(string) + "', null);\n");
                        ++n;
                        if (!"1".equals(string3)) {
                            stringBuffer.append("setNode(" + n + ", 2, 2, 'type', '${text.tree.increment}: " + PageParser.escapeJavaScript(string3) + "', null);\n");
                            ++n;
                        }
                        ++n2;
                    }
                    object.close();
                    object = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.USERS ORDER BY NAME");
                    n2 = 0;
                    while (object.next()) {
                        if (n2 == 0) {
                            stringBuffer.append("setNode(" + n + ", 0, 1, 'users', '${text.tree.users}', null);\n");
                            ++n;
                        }
                        string2 = object.getString("NAME");
                        string = object.getString("ADMIN");
                        stringBuffer.append("setNode(" + n + ", 1, 1, 'user', '" + PageParser.escapeJavaScript(string2) + "', null);\n");
                        ++n;
                        if (string.equalsIgnoreCase("TRUE")) {
                            stringBuffer.append("setNode(" + n + ", 2, 2, 'type', '${text.tree.admin}', null);\n");
                            ++n;
                        }
                        ++n2;
                    }
                    object.close();
                }
                finally {
                    JdbcUtils.closeSilently(statement);
                }
            }
            String string = databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion();
            stringBuffer.append("setNode(" + n + ", 0, 0, 'info', '" + PageParser.escapeJavaScript(string) + "', null);\n");
            stringBuffer.append("refreshQueryTables();");
            this.session.put("tree", stringBuffer.toString());
        }
        catch (Exception exception) {
            this.session.put("tree", "");
            this.session.put("error", this.getStackTrace(0, exception, bl));
        }
        return "tables.jsp";
    }

    private String getStackTrace(int n, Throwable throwable, boolean bl) {
        try {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            string = PageParser.escapeHtml(string);
            if (bl) {
                string = this.linkToSource(string);
            }
            string = StringUtils.replaceAll(string, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            String string2 = PageParser.escapeHtml(throwable.getMessage());
            String string3 = "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('st" + n + "').style;x.display=x.display==''?'none':'';\">" + string2 + "</a>";
            if (throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                string3 = string3 + " " + sQLException.getSQLState() + "/" + sQLException.getErrorCode();
                if (bl) {
                    int n2 = sQLException.getErrorCode();
                    string3 = string3 + " <a href=\"http://h2database.com/javadoc/org/h2/constant/ErrorCode.html#c" + n2 + "\">(${text.a.help})</a>";
                }
            }
            string3 = string3 + "<span style=\"display: none;\" id=\"st" + n + "\"><br />" + string + "</span>";
            string3 = this.formatAsError(string3);
            return string3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }

    private String linkToSource(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = string.indexOf("<br />");
            stringBuffer.append(string.substring(0, n));
            while (true) {
                int n2;
                if ((n2 = string.indexOf("org.h2.", n)) < 0) {
                    stringBuffer.append(string.substring(n));
                    break;
                }
                stringBuffer.append(string.substring(n, n2));
                int n3 = string.indexOf(41, n2);
                if (n3 < 0) {
                    stringBuffer.append(string.substring(n));
                    break;
                }
                String string2 = string.substring(n2, n3);
                int n4 = string2.lastIndexOf(40);
                int n5 = string2.lastIndexOf(46, n4 - 1);
                int n6 = string2.lastIndexOf(46, n5 - 1);
                String string3 = string2.substring(0, n6);
                int n7 = string2.lastIndexOf(58);
                String string4 = string2.substring(n4 + 1, n7);
                String string5 = string2.substring(n7 + 1, string2.length());
                String string6 = string3.replace('.', '/') + "/" + string4;
                stringBuffer.append("<a href=\"http://h2database.com/html/source.html?file=");
                stringBuffer.append(string6);
                stringBuffer.append("&line=");
                stringBuffer.append(string5);
                stringBuffer.append("&build=");
                stringBuffer.append(78);
                stringBuffer.append("\">");
                stringBuffer.append(string2);
                stringBuffer.append("</a>");
                n = n3;
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    private String formatAsError(String string) {
        return "<div class=\"error\">" + string + "</div>";
    }

    private String test() {
        String string = this.attributes.getProperty("driver", "");
        String string2 = this.attributes.getProperty("url", "");
        String string3 = this.attributes.getProperty("user", "");
        String string4 = this.attributes.getProperty("password", "");
        this.session.put("driver", string);
        this.session.put("url", string2);
        this.session.put("user", string3);
        boolean bl = string2.startsWith("jdbc:h2:");
        try {
            Connection connection = this.server.getConnection(string, string2, string3, string4, this);
            JdbcUtils.closeSilently(connection);
            this.session.put("error", "${text.login.testSuccessful}");
            return "login.jsp";
        }
        catch (Exception exception) {
            this.session.put("error", this.getLoginError(exception, bl));
            return "login.jsp";
        }
    }

    String getLoginError(Exception exception, boolean bl) {
        if (exception instanceof JdbcSQLException && ((JdbcSQLException)exception).getErrorCode() == 90086) {
            return "${text.login.driverNotFound}<br />" + this.getStackTrace(0, exception, bl);
        }
        return this.getStackTrace(0, exception, bl);
    }

    private String login() {
        String string = this.attributes.getProperty("driver", "");
        String string2 = this.attributes.getProperty("url", "");
        String string3 = this.attributes.getProperty("user", "");
        String string4 = this.attributes.getProperty("password", "");
        this.session.put("autoCommit", "checked");
        this.session.put("autoComplete", "1");
        this.session.put("maxrows", "1000");
        boolean bl = false;
        if (this.socket != null && string2.startsWith("jdbc:h2:") && !string2.startsWith("jdbc:h2:tcp:") && !string2.startsWith("jdbc:h2:ssl:") && !string2.startsWith("jdbc:h2:mem:")) {
            bl = true;
        }
        if (!bl) {
            boolean bl2 = string2.startsWith("jdbc:h2:");
            try {
                Connection connection = this.server.getConnection(string, string2, string3, string4, this);
                this.session.setConnection(connection);
                this.session.put("url", string2);
                this.session.put("user", string3);
                this.session.remove("error");
                this.settingSave();
                return "frame.jsp";
            }
            catch (Exception exception) {
                this.session.put("error", this.getLoginError(exception, bl2));
                return "login.jsp";
            }
        }
        try {
            class LoginTask
            implements Runnable,
            DatabaseEventListener {
                private final PrintWriter writer;
                private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                private final /* synthetic */ String val$url;
                private final /* synthetic */ String val$user;
                private final /* synthetic */ String val$driver;
                private final /* synthetic */ String val$password;

                LoginTask(String string, String string2, String string3, String string4) throws IOException {
                    this.val$url = string;
                    this.val$user = string2;
                    this.val$driver = string3;
                    this.val$password = string4;
                    String string5 = "HTTP/1.1 200 OK\n";
                    string5 = string5 + "Content-Type: " + WebThread.this.mimeType + "\n\n";
                    WebThread.this.output.write(string5.getBytes());
                    this.writer = new PrintWriter(WebThread.this.output);
                    this.writer.println("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\" /></head>");
                    this.writer.println("<body><h2>Opening Database</h2>URL: " + PageParser.escapeHtml(this.val$url) + "<br />");
                    this.writer.println("User: " + PageParser.escapeHtml(this.val$user) + "<br />");
                    this.writer.println("Version: " + Constants.getFullVersion() + "<br /><br />");
                    this.writer.flush();
                    this.log("Start...");
                }

                public void closingDatabase() {
                    this.log("Closing database");
                }

                public void diskSpaceIsLow(long l) {
                    this.log("Disk space is low; still available: " + l);
                }

                public void exceptionThrown(SQLException sQLException, String string) {
                    this.log("Exception: " + PageParser.escapeHtml(sQLException.toString()) + " SQL: " + PageParser.escapeHtml(string));
                    WebThread.this.server.traceError(sQLException);
                }

                public void init(String string) {
                    this.log("Init: " + PageParser.escapeHtml(string));
                }

                public void opened() {
                    this.log("Database was opened");
                }

                public void setProgress(int n, String string, int n2, int n3) {
                    if (n == WebThread.this.listenerLastState) {
                        long l = System.currentTimeMillis();
                        if (l < WebThread.this.listenerLastEvent + 1000L) {
                            return;
                        }
                        WebThread.this.listenerLastEvent = l;
                    } else {
                        WebThread.this.listenerLastState = n;
                    }
                    string = PageParser.escapeHtml(string);
                    switch (n) {
                        case 3: {
                            this.log("Backing up " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        case 1: {
                            this.log("Creating index " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        case 2: {
                            this.log("Recovering " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        case 0: {
                            this.log("Scanning file " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                            break;
                        }
                        default: {
                            this.log("Unknown state: " + n);
                        }
                    }
                }

                private synchronized void log(String string) {
                    if (WebThread.this.output != null) {
                        string = this.dateFormat.format(new Date()) + ": " + string;
                        this.writer.println(string + "<br />");
                        this.writer.flush();
                    }
                    WebThread.this.server.trace(string);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    String string = (String)WebThread.this.session.get("sessionId");
                    boolean bl = this.val$url.startsWith("jdbc:h2:");
                    try {
                        object = WebThread.this.server.getConnection(this.val$driver, this.val$url, this.val$user, this.val$password, this);
                        WebThread.this.session.setConnection((Connection)object);
                        WebThread.this.session.put("url", this.val$url);
                        WebThread.this.session.put("user", this.val$user);
                        WebThread.this.session.remove("error");
                        WebThread.this.settingSave();
                        this.log("OK<script type=\"text/javascript\">top.location=\"frame.jsp?jsessionid=" + string + "\"</script></body></htm>");
                    }
                    catch (Exception exception) {
                        WebThread.this.session.put("error", WebThread.this.getLoginError(exception, bl));
                        this.log("Error<script type=\"text/javascript\">top.location=\"index.jsp?jsessionid=" + string + "\"</script></body></html>");
                    }
                    object = this;
                    synchronized (object) {
                        IOUtils.closeSilently(WebThread.this.output);
                        try {
                            WebThread.this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        WebThread.this.output = null;
                    }
                }
            }
            LoginTask loginTask = new LoginTask(string2, string3, string, string4);
            Thread thread = new Thread(loginTask);
            thread.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private String logout() {
        try {
            Connection connection = this.session.getConnection();
            this.session.setConnection(null);
            this.session.remove("conn");
            this.session.remove("result");
            this.session.remove("tables");
            this.session.remove("user");
            this.session.remove("tool");
            if (connection != null) {
                if (this.session.getShutdownServerOnDisconnect()) {
                    this.server.shutdown();
                } else {
                    connection.close();
                }
            }
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
        return "index.do";
    }

    private String query() {
        String string = this.attributes.getProperty("sql").trim();
        try {
            String string2;
            Connection connection = this.session.getConnection();
            if (string.startsWith("@JAVA")) {
                if (this.server.getAllowScript()) {
                    try {
                        string2 = this.executeJava(string.substring("@JAVA".length()));
                    }
                    catch (Throwable throwable) {
                        string2 = this.getStackTrace(0, throwable, false);
                    }
                } else {
                    string2 = "Executing Java code is not allowed, use command line parameter -webScript";
                }
            } else if ("@AUTOCOMMIT TRUE".equals(string)) {
                connection.setAutoCommit(true);
                string2 = "${text.result.autoCommitOn}";
            } else if ("@AUTOCOMMIT FALSE".equals(string)) {
                connection.setAutoCommit(false);
                string2 = "${text.result.autoCommitOff}";
            } else if (string.startsWith("@TRANSACTION_ISOLATION")) {
                String string3 = string.substring("@TRANSACTION_ISOLATION".length()).trim();
                if (string3.length() > 0) {
                    int n = Integer.parseInt(string3);
                    connection.setTransactionIsolation(n);
                }
                string2 = "Transaction Isolation: " + connection.getTransactionIsolation() + "<br />";
                string2 = string2 + "1: READ_UNCOMMITTED<br />";
                string2 = string2 + "2: READ_COMMITTED<br />";
                string2 = string2 + "4: REPEATABLE_READ<br />";
                string2 = string2 + "8: SERIALIZABLE";
            } else if (string.startsWith("@SET MAXROWS ")) {
                int n = Integer.parseInt(string.substring("@SET MAXROWS ".length()));
                this.session.put("maxrows", "" + n);
                string2 = "${text.result.maxrowsSet}";
            } else {
                CharSequence charSequence;
                ScriptReader scriptReader = new ScriptReader(new StringReader(string));
                ObjectArray objectArray = new ObjectArray();
                while ((charSequence = scriptReader.readStatement()) != null) {
                    objectArray.add(charSequence);
                }
                charSequence = new StringBuffer();
                for (int i = 0; i < objectArray.size(); ++i) {
                    String string4 = (String)objectArray.get(i);
                    if (!string4.startsWith("@")) {
                        ((StringBuffer)charSequence).append(PageParser.escapeHtml(string4 + ";"));
                        ((StringBuffer)charSequence).append("<br />");
                    }
                    ((StringBuffer)charSequence).append(this.getResult(connection, i + 1, string4, objectArray.size() == 1, false));
                    ((StringBuffer)charSequence).append("<br />");
                }
                string2 = ((StringBuffer)charSequence).toString();
            }
            this.session.put("result", string2);
        }
        catch (Throwable throwable) {
            this.session.put("result", this.getStackTrace(0, throwable, this.session.getContents().isH2));
        }
        return "result.jsp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeJava(String string) throws Exception {
        File file = new File("Java.java");
        File file2 = new File("Java.class");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            file2.delete();
            int n = string.indexOf("@CODE");
            String string2 = "import java.util.*; import java.math.*; import java.sql.*;";
            if (n >= 0) {
                string2 = string.substring(0, n);
                string = string.substring("@CODE".length() + n);
            }
            printWriter.println(string2);
            printWriter.println("public class Java { public static Object run() throws Throwable {" + string + "}}");
            printWriter.close();
            Class<?> clazz = Class.forName("com.sun.tools.javac.Main");
            Method method = clazz.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = WebThread.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Object obj = clazz.newInstance();
            method.invoke(obj, new Object[]{new String[]{"Java.java"}});
            byte[] byArray = new byte[(int)file2.length()];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file2));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            DynamicClassLoader dynamicClassLoader = new DynamicClassLoader("Java", byArray);
            Class clazz2 = dynamicClassLoader.loadClass("Java");
            Method[] methodArray = clazz2.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method2 = methodArray[i];
                if (!method2.getName().equals("run")) continue;
                String string3 = "" + method2.invoke(null, new Object[0]);
                return string3;
            }
            String string4 = null;
            return string4;
        }
        finally {
            file.delete();
            file2.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String editResult() {
        String string;
        String string2;
        block11: {
            ResultSet resultSet = this.session.result;
            int n = Integer.parseInt(this.attributes.getProperty("row"));
            int n2 = Integer.parseInt(this.attributes.getProperty("op"));
            string2 = "";
            string = "";
            try {
                if (n2 == 1) {
                    boolean bl;
                    boolean bl2 = bl = n < 0;
                    if (bl) {
                        resultSet.moveToInsertRow();
                    } else {
                        resultSet.absolute(n);
                    }
                    for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                        String string3 = this.attributes.getProperty("r" + n + "c" + (i + 1));
                        resultSet.updateString(i + 1, this.unescapeData(string3));
                    }
                    if (bl) {
                        resultSet.insertRow();
                        break block11;
                    } else {
                        resultSet.updateRow();
                    }
                    break block11;
                }
                if (n2 == 2) {
                    resultSet.absolute(n);
                    resultSet.deleteRow();
                } else if (n2 != 3) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                string2 = "<br />" + this.getStackTrace(0, throwable, this.session.getContents().isH2);
                string = this.formatAsError(throwable.getMessage());
            }
        }
        String string4 = "@EDIT " + (String)this.session.get("resultSetSQL");
        Connection connection = this.session.getConnection();
        string2 = string + this.getResult(connection, -1, string4, true, true) + string2;
        this.session.put("result", string2);
        return "result.jsp";
    }

    private ResultSet getMetaResultSet(Connection connection, String string) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (string.startsWith("@TABLES")) {
            String[] stringArray = this.split(string);
            String[] stringArray2 = stringArray[4] == null ? null : StringUtils.arraySplit(stringArray[4], ',', false);
            return databaseMetaData.getTables(stringArray[1], stringArray[2], stringArray[3], stringArray2);
        }
        if (string.startsWith("@COLUMNS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@INDEX_INFO")) {
            String[] stringArray = this.split(string);
            boolean bl = stringArray[4] == null ? false : Boolean.valueOf(stringArray[4]);
            boolean bl2 = stringArray[5] == null ? false : Boolean.valueOf(stringArray[5]);
            return databaseMetaData.getIndexInfo(stringArray[1], stringArray[2], stringArray[3], bl, bl2);
        }
        if (string.startsWith("@PRIMARY_KEYS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getPrimaryKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@PROCEDURES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getProcedures(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@PROCEDURE_COLUMNS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getProcedureColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@SCHEMAS")) {
            return databaseMetaData.getSchemas();
        }
        if (string.startsWith("@CATALOG")) {
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("CATALOG", 12, 0, 0);
            simpleResultSet.addRow(new String[]{connection.getCatalog()});
            return simpleResultSet;
        }
        if (string.startsWith("@MEMORY")) {
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("Type", 12, 0, 0);
            simpleResultSet.addColumn("Value", 12, 0, 0);
            simpleResultSet.addRow(new String[]{"Used Memory", "" + MemoryUtils.getMemoryUsed()});
            simpleResultSet.addRow(new String[]{"Free Memory", "" + MemoryUtils.getMemoryFree()});
            return simpleResultSet;
        }
        if (string.startsWith("@INFO")) {
            String string2;
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.addColumn("KEY", 12, 0, 0);
            simpleResultSet.addColumn("VALUE", 12, 0, 0);
            simpleResultSet.addRow(new String[]{"conn.getCatalog", connection.getCatalog()});
            simpleResultSet.addRow(new String[]{"conn.getAutoCommit", "" + connection.getAutoCommit()});
            simpleResultSet.addRow(new String[]{"conn.getTransactionIsolation", "" + connection.getTransactionIsolation()});
            simpleResultSet.addRow(new String[]{"conn.getWarnings", "" + connection.getWarnings()});
            try {
                string2 = "" + connection.getTypeMap();
            }
            catch (SQLException sQLException) {
                string2 = sQLException.toString();
            }
            simpleResultSet.addRow(new String[]{"conn.getTypeMap", "" + string2});
            simpleResultSet.addRow(new String[]{"conn.isReadOnly", "" + connection.isReadOnly()});
            simpleResultSet.addRow(new String[]{"meta.getCatalogSeparator", "" + databaseMetaData.getCatalogSeparator()});
            simpleResultSet.addRow(new String[]{"meta.getCatalogTerm", "" + databaseMetaData.getCatalogTerm()});
            simpleResultSet.addRow(new String[]{"meta.getDatabaseProductName", "" + databaseMetaData.getDatabaseProductName()});
            simpleResultSet.addRow(new String[]{"meta.getDatabaseProductVersion", "" + databaseMetaData.getDatabaseProductVersion()});
            simpleResultSet.addRow(new String[]{"meta.getDefaultTransactionIsolation", "" + databaseMetaData.getDefaultTransactionIsolation()});
            simpleResultSet.addRow(new String[]{"meta.getDriverMajorVersion", "" + databaseMetaData.getDriverMajorVersion()});
            simpleResultSet.addRow(new String[]{"meta.getDriverMinorVersion", "" + databaseMetaData.getDriverMinorVersion()});
            simpleResultSet.addRow(new String[]{"meta.getDriverName", "" + databaseMetaData.getDriverName()});
            simpleResultSet.addRow(new String[]{"meta.getDriverVersion", "" + databaseMetaData.getDriverVersion()});
            simpleResultSet.addRow(new String[]{"meta.getExtraNameCharacters", "" + databaseMetaData.getExtraNameCharacters()});
            simpleResultSet.addRow(new String[]{"meta.getIdentifierQuoteString", "" + databaseMetaData.getIdentifierQuoteString()});
            simpleResultSet.addRow(new String[]{"meta.getMaxBinaryLiteralLength", "" + databaseMetaData.getMaxBinaryLiteralLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxCatalogNameLength", "" + databaseMetaData.getMaxCatalogNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxCharLiteralLength", "" + databaseMetaData.getMaxCharLiteralLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxColumnNameLength", "" + databaseMetaData.getMaxColumnNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxColumnsInGroupBy", "" + databaseMetaData.getMaxColumnsInGroupBy()});
            simpleResultSet.addRow(new String[]{"meta.getMaxColumnsInIndex", "" + databaseMetaData.getMaxColumnsInIndex()});
            simpleResultSet.addRow(new String[]{"meta.getMaxColumnsInOrderBy", "" + databaseMetaData.getMaxColumnsInOrderBy()});
            simpleResultSet.addRow(new String[]{"meta.getMaxColumnsInSelect", "" + databaseMetaData.getMaxColumnsInSelect()});
            simpleResultSet.addRow(new String[]{"meta.getMaxColumnsInTable", "" + databaseMetaData.getMaxColumnsInTable()});
            simpleResultSet.addRow(new String[]{"meta.getMaxConnections", "" + databaseMetaData.getMaxConnections()});
            simpleResultSet.addRow(new String[]{"meta.getMaxCursorNameLength", "" + databaseMetaData.getMaxCursorNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxIndexLength", "" + databaseMetaData.getMaxIndexLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxProcedureNameLength", "" + databaseMetaData.getMaxProcedureNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxRowSize", "" + databaseMetaData.getMaxRowSize()});
            simpleResultSet.addRow(new String[]{"meta.getMaxSchemaNameLength", "" + databaseMetaData.getMaxSchemaNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxStatementLength", "" + databaseMetaData.getMaxStatementLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxStatements", "" + databaseMetaData.getMaxStatements()});
            simpleResultSet.addRow(new String[]{"meta.getMaxTableNameLength", "" + databaseMetaData.getMaxTableNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getMaxTablesInSelect", "" + databaseMetaData.getMaxTablesInSelect()});
            simpleResultSet.addRow(new String[]{"meta.getMaxUserNameLength", "" + databaseMetaData.getMaxUserNameLength()});
            simpleResultSet.addRow(new String[]{"meta.getNumericFunctions", "" + databaseMetaData.getNumericFunctions()});
            simpleResultSet.addRow(new String[]{"meta.getProcedureTerm", "" + databaseMetaData.getProcedureTerm()});
            simpleResultSet.addRow(new String[]{"meta.getSchemaTerm", "" + databaseMetaData.getSchemaTerm()});
            simpleResultSet.addRow(new String[]{"meta.getSearchStringEscape", "" + databaseMetaData.getSearchStringEscape()});
            simpleResultSet.addRow(new String[]{"meta.getSQLKeywords", "" + databaseMetaData.getSQLKeywords()});
            simpleResultSet.addRow(new String[]{"meta.getStringFunctions", "" + databaseMetaData.getStringFunctions()});
            simpleResultSet.addRow(new String[]{"meta.getSystemFunctions", "" + databaseMetaData.getSystemFunctions()});
            simpleResultSet.addRow(new String[]{"meta.getTimeDateFunctions", "" + databaseMetaData.getTimeDateFunctions()});
            simpleResultSet.addRow(new String[]{"meta.getURL", "" + databaseMetaData.getURL()});
            simpleResultSet.addRow(new String[]{"meta.getUserName", "" + databaseMetaData.getUserName()});
            simpleResultSet.addRow(new String[]{"meta.isCatalogAtStart", "" + databaseMetaData.isCatalogAtStart()});
            simpleResultSet.addRow(new String[]{"meta.isReadOnly", "" + databaseMetaData.isReadOnly()});
            simpleResultSet.addRow(new String[]{"meta.allProceduresAreCallable", "" + databaseMetaData.allProceduresAreCallable()});
            simpleResultSet.addRow(new String[]{"meta.allTablesAreSelectable", "" + databaseMetaData.allTablesAreSelectable()});
            simpleResultSet.addRow(new String[]{"meta.dataDefinitionCausesTransactionCommit", "" + databaseMetaData.dataDefinitionCausesTransactionCommit()});
            simpleResultSet.addRow(new String[]{"meta.dataDefinitionIgnoredInTransactions", "" + databaseMetaData.dataDefinitionIgnoredInTransactions()});
            simpleResultSet.addRow(new String[]{"meta.doesMaxRowSizeIncludeBlobs", "" + databaseMetaData.doesMaxRowSizeIncludeBlobs()});
            simpleResultSet.addRow(new String[]{"meta.nullPlusNonNullIsNull", "" + databaseMetaData.nullPlusNonNullIsNull()});
            simpleResultSet.addRow(new String[]{"meta.nullsAreSortedAtEnd", "" + databaseMetaData.nullsAreSortedAtEnd()});
            simpleResultSet.addRow(new String[]{"meta.nullsAreSortedAtStart", "" + databaseMetaData.nullsAreSortedAtStart()});
            simpleResultSet.addRow(new String[]{"meta.nullsAreSortedHigh", "" + databaseMetaData.nullsAreSortedHigh()});
            simpleResultSet.addRow(new String[]{"meta.nullsAreSortedLow", "" + databaseMetaData.nullsAreSortedLow()});
            simpleResultSet.addRow(new String[]{"meta.storesLowerCaseIdentifiers", "" + databaseMetaData.storesLowerCaseIdentifiers()});
            simpleResultSet.addRow(new String[]{"meta.storesLowerCaseQuotedIdentifiers", "" + databaseMetaData.storesLowerCaseQuotedIdentifiers()});
            simpleResultSet.addRow(new String[]{"meta.storesMixedCaseIdentifiers", "" + databaseMetaData.storesMixedCaseIdentifiers()});
            simpleResultSet.addRow(new String[]{"meta.storesMixedCaseQuotedIdentifiers", "" + databaseMetaData.storesMixedCaseQuotedIdentifiers()});
            simpleResultSet.addRow(new String[]{"meta.storesUpperCaseIdentifiers", "" + databaseMetaData.storesUpperCaseIdentifiers()});
            simpleResultSet.addRow(new String[]{"meta.storesUpperCaseQuotedIdentifiers", "" + databaseMetaData.storesUpperCaseQuotedIdentifiers()});
            simpleResultSet.addRow(new String[]{"meta.supportsAlterTableWithAddColumn", "" + databaseMetaData.supportsAlterTableWithAddColumn()});
            simpleResultSet.addRow(new String[]{"meta.supportsAlterTableWithDropColumn", "" + databaseMetaData.supportsAlterTableWithDropColumn()});
            simpleResultSet.addRow(new String[]{"meta.supportsANSI92EntryLevelSQL", "" + databaseMetaData.supportsANSI92EntryLevelSQL()});
            simpleResultSet.addRow(new String[]{"meta.supportsANSI92FullSQL", "" + databaseMetaData.supportsANSI92FullSQL()});
            simpleResultSet.addRow(new String[]{"meta.supportsANSI92IntermediateSQL", "" + databaseMetaData.supportsANSI92IntermediateSQL()});
            simpleResultSet.addRow(new String[]{"meta.supportsBatchUpdates", "" + databaseMetaData.supportsBatchUpdates()});
            simpleResultSet.addRow(new String[]{"meta.supportsCatalogsInDataManipulation", "" + databaseMetaData.supportsCatalogsInDataManipulation()});
            simpleResultSet.addRow(new String[]{"meta.supportsCatalogsInIndexDefinitions", "" + databaseMetaData.supportsCatalogsInIndexDefinitions()});
            simpleResultSet.addRow(new String[]{"meta.supportsCatalogsInPrivilegeDefinitions", "" + databaseMetaData.supportsCatalogsInPrivilegeDefinitions()});
            simpleResultSet.addRow(new String[]{"meta.supportsCatalogsInProcedureCalls", "" + databaseMetaData.supportsCatalogsInProcedureCalls()});
            simpleResultSet.addRow(new String[]{"meta.supportsCatalogsInTableDefinitions", "" + databaseMetaData.supportsCatalogsInTableDefinitions()});
            simpleResultSet.addRow(new String[]{"meta.supportsColumnAliasing", "" + databaseMetaData.supportsColumnAliasing()});
            simpleResultSet.addRow(new String[]{"meta.supportsConvert", "" + databaseMetaData.supportsConvert()});
            simpleResultSet.addRow(new String[]{"meta.supportsCoreSQLGrammar", "" + databaseMetaData.supportsCoreSQLGrammar()});
            simpleResultSet.addRow(new String[]{"meta.supportsCorrelatedSubqueries", "" + databaseMetaData.supportsCorrelatedSubqueries()});
            simpleResultSet.addRow(new String[]{"meta.supportsDataDefinitionAndDataManipulationTransactions", "" + databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions()});
            simpleResultSet.addRow(new String[]{"meta.supportsDataManipulationTransactionsOnly", "" + databaseMetaData.supportsDataManipulationTransactionsOnly()});
            simpleResultSet.addRow(new String[]{"meta.supportsDifferentTableCorrelationNames", "" + databaseMetaData.supportsDifferentTableCorrelationNames()});
            simpleResultSet.addRow(new String[]{"meta.supportsExpressionsInOrderBy", "" + databaseMetaData.supportsExpressionsInOrderBy()});
            simpleResultSet.addRow(new String[]{"meta.supportsExtendedSQLGrammar", "" + databaseMetaData.supportsExtendedSQLGrammar()});
            simpleResultSet.addRow(new String[]{"meta.supportsFullOuterJoins", "" + databaseMetaData.supportsFullOuterJoins()});
            simpleResultSet.addRow(new String[]{"meta.supportsGroupBy", "" + databaseMetaData.supportsGroupBy()});
            simpleResultSet.addRow(new String[]{"meta.usesLocalFilePerTable", "" + databaseMetaData.usesLocalFilePerTable()});
            simpleResultSet.addRow(new String[]{"meta.usesLocalFiles", "" + databaseMetaData.usesLocalFiles()});
            simpleResultSet.addRow(new String[]{"conn.getHoldability", "" + connection.getHoldability()});
            simpleResultSet.addRow(new String[]{"meta.getDatabaseMajorVersion", "" + databaseMetaData.getDatabaseMajorVersion()});
            simpleResultSet.addRow(new String[]{"meta.getDatabaseMinorVersion", "" + databaseMetaData.getDatabaseMinorVersion()});
            simpleResultSet.addRow(new String[]{"meta.getJDBCMajorVersion", "" + databaseMetaData.getJDBCMajorVersion()});
            simpleResultSet.addRow(new String[]{"meta.getJDBCMinorVersion", "" + databaseMetaData.getJDBCMinorVersion()});
            simpleResultSet.addRow(new String[]{"meta.getResultSetHoldability", "" + databaseMetaData.getResultSetHoldability()});
            simpleResultSet.addRow(new String[]{"meta.getSQLStateType", "" + databaseMetaData.getSQLStateType()});
            simpleResultSet.addRow(new String[]{"meta.supportsGetGeneratedKeys", "" + databaseMetaData.supportsGetGeneratedKeys()});
            simpleResultSet.addRow(new String[]{"meta.locatorsUpdateCopy", "" + databaseMetaData.locatorsUpdateCopy()});
            return simpleResultSet;
        }
        if (string.startsWith("@CATALOGS")) {
            return databaseMetaData.getCatalogs();
        }
        if (string.startsWith("@TABLE_TYPES")) {
            return databaseMetaData.getTableTypes();
        }
        if (string.startsWith("@COLUMN_PRIVILEGES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getColumnPrivileges(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        if (string.startsWith("@TABLE_PRIVILEGES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getTablePrivileges(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@BEST_ROW_IDENTIFIER")) {
            String[] stringArray = this.split(string);
            int n = stringArray[4] == null ? 0 : Integer.parseInt(stringArray[4]);
            boolean bl = stringArray[5] == null ? false : Boolean.valueOf(stringArray[5]);
            return databaseMetaData.getBestRowIdentifier(stringArray[1], stringArray[2], stringArray[3], n, bl);
        }
        if (string.startsWith("@VERSION_COLUMNS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getVersionColumns(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@IMPORTED_KEYS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getImportedKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@EXPORTED_KEYS")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getExportedKeys(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@CROSS_REFERENCE")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getCrossReference(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
        }
        if (string.startsWith("@UDTS")) {
            int[] nArray;
            String[] stringArray = this.split(string);
            if (stringArray[4] == null) {
                nArray = null;
            } else {
                String[] stringArray3 = StringUtils.arraySplit(stringArray[4], ',', false);
                nArray = new int[stringArray3.length];
                for (int i = 0; i < stringArray3.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray3[i]);
                }
            }
            return databaseMetaData.getUDTs(stringArray[1], stringArray[2], stringArray[3], nArray);
        }
        if (string.startsWith("@TYPE_INFO")) {
            return databaseMetaData.getTypeInfo();
        }
        if (string.startsWith("@SUPER_TYPES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getSuperTypes(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@SUPER_TABLES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getSuperTables(stringArray[1], stringArray[2], stringArray[3]);
        }
        if (string.startsWith("@ATTRIBUTES")) {
            String[] stringArray = this.split(string);
            return databaseMetaData.getAttributes(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        }
        return null;
    }

    private String[] split(String string) {
        String[] stringArray = new String[10];
        String[] stringArray2 = StringUtils.arraySplit(string, ' ', true);
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"null".equals(stringArray[i])) continue;
            stringArray[i] = null;
        }
        return stringArray;
    }

    private int getMaxrows() {
        String string = (String)this.session.get("maxrows");
        int n = string == null ? 0 : Integer.parseInt(string);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResult(Connection connection, int n, String string, boolean bl, boolean bl2) {
        String string2;
        try {
            ResultSet resultSet;
            Object object;
            string = string.trim();
            StringBuffer stringBuffer = new StringBuffer();
            string2 = StringUtils.toUpperEnglish(string);
            if (string2.indexOf("CREATE") >= 0 || string2.indexOf("DROP") >= 0 || string2.indexOf("ALTER") >= 0 || string2.indexOf("RUNSCRIPT") >= 0) {
                object = this.attributes.getProperty("jsessionid");
                stringBuffer.append("<script type=\"text/javascript\">top['h2menu'].location='tables.do?jsessionid=" + (String)object + "';</script>");
            }
            DbContents dbContents = this.session.getContents();
            object = bl2 || bl && dbContents.isH2 ? connection.createStatement(1004, 1008) : connection.createStatement();
            long l = System.currentTimeMillis();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if ("@CANCEL".equals(string)) {
                object = this.session.executingStatement;
                if (object != null) {
                    object.cancel();
                    stringBuffer.append("${text.result.statementWasCancelled}");
                } else {
                    stringBuffer.append("${text.result.noRunningStatement}");
                }
                String string3 = stringBuffer.toString();
                return string3;
            }
            if (string.startsWith("@PARAMETER_META")) {
                string = string.substring("@PARAMETER_META".length()).trim();
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                stringBuffer.append(this.getParameterResultSet(preparedStatement.getParameterMetaData()));
                String string4 = stringBuffer.toString();
                return string4;
            }
            if (string.startsWith("@META")) {
                bl3 = true;
                string = string.substring("@META".length()).trim();
            } else if (string.startsWith("@LIST")) {
                bl6 = true;
                string = string.substring("@LIST".length()).trim();
            } else if (string.startsWith("@GENERATED")) {
                bl4 = true;
                string = string.substring("@GENERATED".length()).trim();
            } else {
                if (string.startsWith("@LOOP")) {
                    string = string.substring("@LOOP".length()).trim();
                    int n2 = string.indexOf(32);
                    int n3 = MathUtils.decodeInt(string.substring(0, n2));
                    string = string.substring(n2).trim();
                    String string5 = this.executeLoop(connection, n3, string);
                    return string5;
                }
                if (string.startsWith("@EDIT")) {
                    bl5 = true;
                    string = string.substring("@EDIT".length()).trim();
                    this.session.put("resultSetSQL", string);
                } else if ("@HISTORY".equals(string)) {
                    stringBuffer.append(this.getHistoryString());
                    String string6 = stringBuffer.toString();
                    return string6;
                }
            }
            if (string.startsWith("@")) {
                resultSet = this.getMetaResultSet(connection, string);
                if (resultSet == null) {
                    stringBuffer.append("?: " + string);
                    String string7 = stringBuffer.toString();
                    return string7;
                }
            } else {
                int n4 = this.getMaxrows();
                object.setMaxRows(n4);
                this.session.executingStatement = object;
                boolean bl7 = object.execute(string);
                this.session.addCommand(string);
                if (bl4) {
                    resultSet = null;
                    resultSet = object.getGeneratedKeys();
                } else {
                    if (!bl7) {
                        stringBuffer.append("${text.result.updateCount}: " + object.getUpdateCount());
                        l = System.currentTimeMillis() - l;
                        stringBuffer.append("<br />(");
                        stringBuffer.append(l);
                        stringBuffer.append(" ms)");
                        object.close();
                        String string8 = stringBuffer.toString();
                        return string8;
                    }
                    resultSet = object.getResultSet();
                }
            }
            l = System.currentTimeMillis() - l;
            stringBuffer.append(this.getResultSet(string, resultSet, bl3, bl6, bl5, l, bl));
            if (!bl5) {
                object.close();
            }
            String string9 = stringBuffer.toString();
            return string9;
        }
        catch (Throwable throwable) {
            string2 = this.getStackTrace(n, throwable, this.session.getContents().isH2);
            return string2;
        }
        finally {
            this.session.executingStatement = null;
        }
    }

    private String executeLoop(Connection connection, int n, String string) throws SQLException {
        int n2;
        Object object;
        boolean bl;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        while (!this.stop && (n3 = string.indexOf(63, n3)) >= 0) {
            if (string.substring(n3).startsWith("?/*RND*/")) {
                arrayList.add(ObjectUtils.getInteger(1));
                string = string.substring(0, n3) + "?" + string.substring(n3 + "/*RND*/".length() + 1);
            } else {
                arrayList.add(ObjectUtils.getInteger(0));
            }
            ++n3;
        }
        int n4 = 0;
        Random random = new Random(1L);
        long l = System.currentTimeMillis();
        if (string.startsWith("@STATEMENT")) {
            string = string.substring("@STATEMENT".length()).trim();
            bl = false;
            object = connection.createStatement();
            for (n2 = 0; !this.stop && n2 < n; ++n2) {
                String string2 = string;
                for (int i = 0; i < arrayList.size(); ++i) {
                    n3 = string2.indexOf(63);
                    Integer n5 = (Integer)arrayList.get(i);
                    string2 = n5 == 1 ? string2.substring(0, n3) + random.nextInt(n) + string2.substring(n3 + 1) : string2.substring(0, n3) + n2 + string2.substring(n3 + 1);
                }
                if (!object.execute(string2)) continue;
                ResultSet resultSet = object.getResultSet();
                while (!this.stop && resultSet.next()) {
                    ++n4;
                }
                resultSet.close();
            }
        } else {
            bl = true;
            object = connection.prepareStatement(string);
            for (n2 = 0; !this.stop && n2 < n; ++n2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Integer n6 = (Integer)arrayList.get(i);
                    if (n6 == 1) {
                        object.setInt(i + 1, random.nextInt(n));
                        continue;
                    }
                    object.setInt(i + 1, n2);
                }
                if (this.session.getContents().isSQLite) {
                    object.executeUpdate();
                    continue;
                }
                if (!object.execute()) continue;
                ResultSet resultSet = object.getResultSet();
                while (!this.stop && resultSet.next()) {
                    ++n4;
                }
                resultSet.close();
            }
        }
        l = System.currentTimeMillis() - l;
        object = l + " ms: " + n + " * ";
        object = bl ? (String)object + "(Prepared) " : (String)object + "(Statement) ";
        object = (String)object + "(";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((Integer)arrayList.get(i) == 0 ? "i" : "rnd");
        }
        object = (String)object + stringBuffer.toString();
        object = (String)object + ") " + string;
        return object;
    }

    private String getHistoryString() {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = this.session.getCommands();
        stringBuffer.append("<table cellspacing=0 cellpadding=0>");
        stringBuffer.append("<tr><th></th><th>Command</th></tr>");
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string = (String)arrayList.get(i);
            stringBuffer.append("<tr><td>");
            stringBuffer.append("<a href=\"getHistory.do?id=");
            stringBuffer.append(i);
            stringBuffer.append("&jsessionid=${sessionId}\" target=\"h2query\" ><img width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/></a>");
            stringBuffer.append("</td><td>");
            stringBuffer.append(PageParser.escapeHtml(string));
            stringBuffer.append("</td></tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String getParameterResultSet(ParameterMetaData parameterMetaData) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (parameterMetaData == null) {
            return "No parameter meta data";
        }
        stringBuffer.append("<table cellspacing=0 cellpadding=0>");
        stringBuffer.append("<tr><th>className</th><th>mode</th><th>type</th>");
        stringBuffer.append("<th>typeName</th><th>precision</th><th>scale</th></tr>");
        for (int i = 0; i < parameterMetaData.getParameterCount(); ++i) {
            stringBuffer.append("</tr><td>");
            stringBuffer.append(parameterMetaData.getParameterClassName(i + 1));
            stringBuffer.append("</td><td>");
            stringBuffer.append(parameterMetaData.getParameterMode(i + 1));
            stringBuffer.append("</td><td>");
            stringBuffer.append(parameterMetaData.getParameterType(i + 1));
            stringBuffer.append("</td><td>");
            stringBuffer.append(parameterMetaData.getParameterTypeName(i + 1));
            stringBuffer.append("</td><td>");
            stringBuffer.append(parameterMetaData.getPrecision(i + 1));
            stringBuffer.append("</td><td>");
            stringBuffer.append(parameterMetaData.getScale(i + 1));
            stringBuffer.append("</td></tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String getResultSet(String string, ResultSet resultSet, boolean bl, boolean bl2, boolean bl3, long l, boolean bl4) throws SQLException {
        int n;
        int n2 = this.getMaxrows();
        l = System.currentTimeMillis() - l;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl3) {
            stringBuffer.append("<form id=\"editing\" name=\"editing\" method=\"post\" action=\"editResult.do?jsessionid=${sessionId}\" id=\"mainForm\" target=\"h2result\">");
            stringBuffer.append("<input type=\"hidden\" name=\"op\" value=\"1\" />");
            stringBuffer.append("<input type=\"hidden\" name=\"row\" value=\"\" />");
            stringBuffer.append("<table cellspacing=0 cellpadding=0 id=\"editTable\">");
        } else {
            stringBuffer.append("<table cellspacing=0 cellpadding=0>");
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = 0;
        if (bl) {
            stringBuffer.append("<tr><th>i</th><th>label</th><th>cat</th><th>schem</th>");
            stringBuffer.append("<th>tab</th><th>col</th><th>type</th><th>typeName</th><th>class</th>");
            stringBuffer.append("<th>prec</th><th>scale</th><th>size</th><th>autoInc</th>");
            stringBuffer.append("<th>case</th><th>currency</th><th>null</th><th>ro</th>");
            stringBuffer.append("<th>search</th><th>sig</th><th>w</th><th>defW</th></tr>");
            for (n = 1; n <= n3; ++n) {
                stringBuffer.append("<tr>");
                stringBuffer.append("<td>").append(n).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n))).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getCatalogName(n))).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getSchemaName(n))).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getTableName(n))).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnName(n))).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.getColumnType(n)).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnTypeName(n))).append("</td>");
                stringBuffer.append("<td>").append(PageParser.escapeHtml(resultSetMetaData.getColumnClassName(n))).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.getPrecision(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.getScale(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.getColumnDisplaySize(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isAutoIncrement(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isCaseSensitive(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isCurrency(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isNullable(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isReadOnly(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isSearchable(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isSigned(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isWritable(n)).append("</td>");
                stringBuffer.append("<td>").append(resultSetMetaData.isDefinitelyWritable(n)).append("</td>");
                stringBuffer.append("</tr>");
            }
        } else if (bl2) {
            stringBuffer.append("<tr><th>Column</th><th>Data</th></tr><tr>");
            while (resultSet.next() && (n2 <= 0 || n4 < n2)) {
                stringBuffer.append("<tr><td>Row #</td><td>");
                stringBuffer.append(++n4);
                stringBuffer.append("</tr>");
                for (n = 0; n < n3; ++n) {
                    stringBuffer.append("<tr><td>");
                    stringBuffer.append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n + 1)));
                    stringBuffer.append("</td>");
                    stringBuffer.append("<td>");
                    stringBuffer.append(this.escapeData(resultSet.getString(n + 1)));
                    stringBuffer.append("</td></tr>");
                }
            }
        } else {
            stringBuffer.append("<tr>");
            if (bl3) {
                stringBuffer.append("<th>Action</th>");
            }
            for (n = 0; n < n3; ++n) {
                stringBuffer.append("<th>");
                stringBuffer.append(PageParser.escapeHtml(resultSetMetaData.getColumnLabel(n + 1)));
                stringBuffer.append("</th>");
            }
            stringBuffer.append("</tr>");
            while (resultSet.next() && (n2 <= 0 || n4 < n2)) {
                ++n4;
                stringBuffer.append("<tr>");
                if (bl3) {
                    stringBuffer.append("<td>");
                    stringBuffer.append("<img onclick=\"javascript:editRow(");
                    stringBuffer.append(resultSet.getRow());
                    stringBuffer.append(",'${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'");
                    stringBuffer.append(")\" width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/>");
                    stringBuffer.append("<a href=\"editResult.do?op=2&row=");
                    stringBuffer.append(resultSet.getRow());
                    stringBuffer.append("&jsessionid=${sessionId}\" target=\"h2result\" ><img width=16 height=16 src=\"ico_remove.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.delete}\" title=\"${text.resultEdit.delete}\" border=\"1\" /></a>");
                    stringBuffer.append("</td>");
                }
                for (n = 0; n < n3; ++n) {
                    stringBuffer.append("<td>");
                    stringBuffer.append(this.escapeData(resultSet.getString(n + 1)));
                    stringBuffer.append("</td>");
                }
                stringBuffer.append("</tr>");
            }
        }
        int n5 = n = resultSet.getConcurrency() == 1008 && resultSet.getType() != 1003 ? 1 : 0;
        if (bl3) {
            ResultSet resultSet2 = this.session.result;
            if (resultSet2 != null) {
                resultSet2.close();
            }
            this.session.result = resultSet;
        } else {
            resultSet.close();
        }
        if (bl3) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append("<img onclick=\"javascript:editRow(-1, '${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'");
            stringBuffer.append(")\" width=16 height=16 src=\"ico_add.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.add}\" title=\"${text.resultEdit.add}\" border=\"1\"/>");
            stringBuffer.append("</td>");
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("<td></td>");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        if (bl3) {
            stringBuffer.append("</form>");
        }
        if (n4 == 0) {
            stringBuffer.append("(${text.result.noRows}");
        } else if (n4 == 1) {
            stringBuffer.append("(${text.result.1row}");
        } else {
            stringBuffer.append("(");
            stringBuffer.append(n4);
            stringBuffer.append(" ${text.result.rows}");
        }
        stringBuffer.append(", ");
        l = System.currentTimeMillis() - l;
        stringBuffer.append(l);
        stringBuffer.append(" ms)");
        if (!bl3 && n != 0 && bl4) {
            stringBuffer.append("<br /><br /><form name=\"editResult\" method=\"post\" action=\"query.do?jsessionid=${sessionId}\" target=\"h2result\">");
            stringBuffer.append("<input type=\"submit\" class=\"button\" value=\"${text.resultEdit.editResult}\" />");
            stringBuffer.append("<input type=\"hidden\" name=\"sql\" value=\"@EDIT " + PageParser.escapeHtml(string) + "\" />");
            stringBuffer.append("</form>");
        }
        return stringBuffer.toString();
    }

    String settingSave() {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.name = this.attributes.getProperty("name", "");
        connectionInfo.driver = this.attributes.getProperty("driver", "");
        connectionInfo.url = this.attributes.getProperty("url", "");
        connectionInfo.user = this.attributes.getProperty("user", "");
        this.server.updateSetting(connectionInfo);
        this.attributes.put("setting", connectionInfo.name);
        this.server.saveSettings();
        return "index.do";
    }

    private String escapeData(String string) {
        if (string == null) {
            return "<i>null</i>";
        }
        if (string.startsWith("null")) {
            return "<div style='display: none'>=</div>" + PageParser.escapeHtml(string);
        }
        return PageParser.escapeHtml(string);
    }

    private String unescapeData(String string) {
        if (string.endsWith("null")) {
            if (string.equals("null")) {
                return null;
            }
            if (string.startsWith("=")) {
                return string.substring(1);
            }
        }
        return string;
    }

    private String settingRemove() {
        String string = this.attributes.getProperty("name", "");
        this.server.removeSetting(string);
        ArrayList arrayList = this.server.getSettings();
        if (arrayList.size() > 0) {
            this.attributes.put("setting", arrayList.get(0));
        }
        this.server.saveSettings();
        return "index.do";
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        return NetUtils.isLoopbackAddress(this.socket);
    }

    String getMimeType() {
        return this.mimeType;
    }

    boolean getCache() {
        return this.cache;
    }

    WebSession getSession() {
        return this.session;
    }

    public void closingDatabase() {
        this.trace("Closing database");
    }

    public void diskSpaceIsLow(long l) {
        this.trace("Disk space is low; still available: " + l);
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        this.trace("Exception: " + sQLException.toString() + " SQL: " + string);
    }

    public void init(String string) {
        this.trace("Init: " + string);
    }

    public void opened() {
        this.trace("Database was opened");
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (n == this.listenerLastState) {
            long l = System.currentTimeMillis();
            if (this.listenerLastEvent + 500L < l) {
                return;
            }
            this.listenerLastEvent = l;
        } else {
            this.listenerLastState = n;
        }
        switch (n) {
            case 3: {
                this.trace("Backing up " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            case 1: {
                this.trace("Creating index " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            case 2: {
                this.trace("Recovering " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            case 0: {
                this.trace("Scanning file " + string + " " + 100L * (long)n2 / (long)n3 + "%");
                break;
            }
            default: {
                this.trace("Unknown state: " + n);
            }
        }
    }

    private void trace(String string) {
        this.server.trace(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DynamicClassLoader
    extends SecureClassLoader {
        private String name;
        private byte[] data;
        private Class clazz;

        DynamicClassLoader(String string, byte[] byArray) {
            super((class$org$h2$server$web$WebThread$DynamicClassLoader == null ? (class$org$h2$server$web$WebThread$DynamicClassLoader = WebThread.class$("org.h2.server.web.WebThread$DynamicClassLoader")) : class$org$h2$server$web$WebThread$DynamicClassLoader).getClassLoader());
            this.name = string;
            this.data = byArray;
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.findClass(string);
        }

        public Class findClass(String string) throws ClassNotFoundException {
            if (string.equals(this.name)) {
                if (this.clazz == null) {
                    this.clazz = this.defineClass(string, this.data, 0, this.data.length);
                }
                return this.clazz;
            }
            try {
                return this.findSystemClass(string);
            }
            catch (Exception exception) {
                return super.findClass(string);
            }
        }
    }

    static class IndexInfo {
        String name;
        String type;
        String columns;

        IndexInfo() {
        }
    }
}

