/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context.support;

import jp.terasoluna.fw.web.rich.context.RequestContext;
import jp.terasoluna.fw.web.rich.context.RequestContextManager;
import jp.terasoluna.fw.web.rich.context.exception.IllegalContextPropertyClassTypeException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.context.support.AbstractRequestContextSupport} NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ߂̕⏕WbNC^tF[XpۃNXB<br>
 * OF
 * <p>
 * @see jp.terasoluna.fw.web.rich.context.support.AbstractRequestContextSupport
 */
public class AbstractRequestContextSupportTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractRequestContextSupportTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            RequestContextManager.unbindRequestContext();
        } catch (Throwable e) {
        }
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public AbstractRequestContextSupportTest(String name) {
        super(name);
    }

    /**
     * testGetRequestName01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() getRequestContext():not null<br>
     * inull͕ԂȂj<br>
     * <br>
     * ҒlF(߂l) String:getRequestContext().getRequestName()̖߂lƓƂmFB<br>
     * <br>
     * NGXg擾郁\bh̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetRequestName01() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        target.setTestCtx(ctx);

        // eXg{E
        assertEquals(target.getRequestContext().getRequestName(), target
                .getRequestName());
    }

    /**
     * testGetProperty01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() key:"arg1"<br>
     * <br>
     * ҒlF(߂l) Object:getRequestContext().getProperty()̖߂lƓƂmFB<br>
     * <br>
     * Ɩp[^擾郁\bh̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetProperty01() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        Object object = new Object();
        ctx.setProperty("arg1", object);
        target.setTestCtx(ctx);

        // eXg{E
        assertSame(object, target.getProperty("arg1"));
    }

    /**
     * testGetPropertyStringClass01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() key:"arg1"<br>
     * clazz:Object.class<br>
     * <br>
     * ҒlF(߂l) Object:getRequestContext().getProperty()̖߂lƓƂmFB<br>
     * <br>
     * Ɩp[^擾郁\bh̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyStringClass01() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        String string = "";
        ctx.setProperty("arg1", string);
        target.setTestCtx(ctx);

        // eXg{E
        assertSame(string, target.getProperty("arg1", String.class));
    }

    /**
     * testGetPropertyStringClass02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() key:"arg1"<br>
     * clazz:String.class<br>
     * <br>
     * ҒlF(O) IllegalArgumentException:<br>
     * bZ[WFMust not use null for clazz of an argument. <br>
     * 擾ƖvpeB̌^w肵Ȃꍇ̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyStringClass02() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        String string = "";
        ctx.setProperty("arg1", string);
        target.setTestCtx(ctx);

        // eXg{
        try {
            target.getProperty("arg1", null);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Must not use null for clazz of an argument.", e
                    .getMessage());
        }
    }

    /**
     * testGetPropertyStringClass03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() key:"arg1"<br>
     * clazz:Integer.class<br>
     * <br>
     * ҒlF(ԕω) O:IllegalContextPropertyClassTypeException<br>
     * <br>
     * 擾ƖvpeB̌^Ǝw肳ꂽ^Ⴄꍇ̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyStringClass03() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        String string = "abc";
        ctx.setProperty("arg1", string);
        target.setTestCtx(ctx);

        // eXg{
        try {
            target.getProperty("arg1", Integer.class);
            fail();
        } catch (IllegalContextPropertyClassTypeException e) {
            // 
            return;
        }
    }

    /**
     * testGetPropertyString01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() key:"arg1"<br>
     * <br>
     * ҒlF(߂l) String:getRequestContext().getProperty()̖߂lƓƂmFB<br>
     * <br>
     * Ɩp[^擾郁\bh̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyString01() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        String string = "";
        ctx.setProperty("arg1", string);
        target.setTestCtx(ctx);

        // eXg{E
        assertSame(string, target.getPropertyString("arg1"));
    }

    /**
     * testGetPropertyString02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() key:"arg1"<br>
     * <br>
     * ҒlF(ԕω) O:IllegalContextPropertyClassTypeException<br>
     * <br>
     * 擾ƖvpeB̌^String^łȂꍇ̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyString02() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        Integer integer = new Integer(1);
        ctx.setProperty("arg1", integer);
        target.setTestCtx(ctx);

        // eXg{
        try {
            target.getPropertyString("arg1");
            fail();
        } catch (IllegalContextPropertyClassTypeException e) {
            // 
            return;
        }

    }

    /**
     * testGenerateContext01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * <br>
     * ҒlF(ԕω) doGenerateContext():\bhĂяoꂽƂmFB<br>
     * (ԕω) RequestContextManager.bindRequestContext():\bhĂяoꂽƂmFB<br>
     * <br>
     * NGXgReLXg𐶐郁\bh̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGenerateContext01() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl01 target = new AbstractRequestContextSupportImpl01();

        // RequestContext̐ݒ
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        target.setTestCtx(ctx);

        // ̐
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        target.generateContext(request);

        // 
        assertTrue(target.isDoGenerateContextCalled());
        assertSame(request, target.getDoGenerateContextArg());

        // sʂČĂяomFƂ
        assertSame(ctx, RequestContextManager.getRequestContext());
    }

    /**
     * testDestroyContext01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() RequestContextManager.hasRequestContext():true<br>
     * <br>
     * ҒlF(ԕω) RequestContextManager.unbindRequestContext():\bhĂяoꂽƂmFB<br>
     * <br>
     * NGXgReLXg폜郁\bh̃eXgBNGXgReLXgĂ߁Aɍ폜B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDestroyContext01() throws Exception {
        // RequestContextManager̐ݒ
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        tlocal.set(ctx);
        UTUtil
                .setPrivateField(RequestContextManager.class, "resources",
                        tlocal);

        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl02 target = new AbstractRequestContextSupportImpl02();

        // eXg{
        target.destroyContext();

        // 
        assertFalse(RequestContextManager.hasRequestContext());
    }

    /**
     * testDestroyContext02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() RequestContextManager.hasRequestContext():false<br>
     * <br>
     * ҒlF(ԕω) RequestContextManager.unbindRequestContext():\bhĂяoĂȂƂmFB<br>
     * <br>
     * NGXgReLXg폜郁\bh̃eXgBNGXgReLXgĂȂ߁AȂŏIB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDestroyContext02() throws Exception {
        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl02 target = new AbstractRequestContextSupportImpl02();

        // eXg{
        target.destroyContext();

        // 
        assertFalse(RequestContextManager.hasRequestContext());

        // ̏unbindRequestContext()Ă΂΁AG[Oo͂
        assertFalse(LogUTUtil.checkError("No RequestContext bound to thread!"));
    }

    /**
     * testGetRequestContext01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) RequestContextManager.getRequestContext()̖߂lƓƂmFB<br>
     * <br>
     * NGXgReLXg擾郁\bh̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetRequestContext01() throws Exception {
        // RequestContextManager̐ݒ
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        tlocal.set(ctx);
        UTUtil
                .setPrivateField(RequestContextManager.class, "resources",
                        tlocal);

        // AbstractRequestContextSupportNX̐
        AbstractRequestContextSupportImpl02 target = new AbstractRequestContextSupportImpl02();

        // eXg{
        RequestContext result = target.getRequestContext();

        // 
        assertSame(RequestContextManager.getRequestContext(), result);
    }

}
