/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.io.impl;

import java.beans.PropertyDescriptor;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.io.impl.AbstractInputSource;
import jp.terasoluna.fw.ex.unit.util.DateConvertUtils;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSource<T>
extends AbstractInputSource<T> {
    protected final JdbcTemplate template;
    protected final Class<T> clazz;
    protected final RowMapper rowMapper;
    protected String sql;
    private Boolean isConvertDate = null;

    public void setIsConvertDate(Boolean isConvertDate) {
        this.isConvertDate = isConvertDate;
    }

    public DbSource(JdbcTemplate template, String tableName, Class<T> clazz) {
        this.header = ReflectionUtils.createFiledNames(clazz);
        this.template = template;
        this.clazz = clazz;
        this.sql = "select * from " + tableName;
        this.rowMapper = new BeanPropertyRowMapper(clazz, false);
    }

    public DbSource(JdbcTemplate template, Class<T> clazz) {
        this(template, clazz.getSimpleName(), clazz);
    }

    public DbSource(JdbcTemplate template, Class<T> clazz, String sql, RowMapper rowMapper) {
        this.header = ReflectionUtils.createFiledNames(clazz);
        this.template = template;
        this.clazz = clazz;
        this.sql = sql;
        this.rowMapper = rowMapper;
    }

    @Override
    public Iterator<T> getIterator() {
        Assert.notNull((Object)this.template);
        List items = this.template.query(this.sql, this.rowMapper);
        for (Object item : items) {
            if (this.isConvertDate != null && this.isConvertDate != Boolean.TRUE) continue;
            BeanWrapperImpl bw = new BeanWrapperImpl(this.clazz);
            this.isConvertDate = Boolean.FALSE;
            PropertyDescriptor[] propertyDescriptorArray = bw.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                Class<?> propertyType = pd.getPropertyType();
                if (Date.class == propertyType) {
                    this.isConvertDate = Boolean.TRUE;
                    try {
                        Date d = (Date)pd.getReadMethod().invoke(item, new Object[0]);
                        Date value = DateConvertUtils.convertDateValue(d, Date.class);
                        pd.getWriteMethod().invoke(item, value);
                    }
                    catch (Exception e) {
                        throw new UTRuntimeException(e);
                    }
                }
                ++n2;
            }
        }
        return items.iterator();
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

