/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.common;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;

/**
 * xX̃p[^NXB
 */
@FileFormat(overWriteFlg=true)
public class SitenData {

    /**
     * xXR[h
     */
    @OutputFileColumn(columnIndex = 0)
    private String sitencd;
    
    /**
     * xX
     */
    @OutputFileColumn(columnIndex = 1)
    private String sitenmei;
    
    /**
     * xXZ
     */
    @OutputFileColumn(columnIndex = 2)
    private String sitenjusyo;
    
    /**
     * xXdbԍ
     */
    @OutputFileColumn(columnIndex = 3)
    private String sitentel;
    
    /**
     * xXR[hԋpB
     * @return xXR[h
     */
    public String getSitencd() {
        return sitencd;
    }
    
    /**
     * xXR[hݒ肷B
     * @param sitencd ݒ肷xXR[h
     */
    public void setSitencd(String sitencd) {
        this.sitencd = sitencd;
    }
    
    /**
     * xXZԋpB
     * @return xXZ
     */
    public String getSitenjusyo() {
        return sitenjusyo;
    }
    
    /**
     * xXZݒ肷B
     * @param sitenjusyo ݒ肷xXZ
     */
    public void setSitenjusyo(String sitenjusyo) {
        this.sitenjusyo = sitenjusyo;
    }
    
    /**
     * xXԋpB
     * @return xX
     */
    public String getSitenmei() {
        return sitenmei;
    }
    
    /**
     * xXݒ肷B
     * @param sitenmei ݒ肷xXB
     */
    public void setSitenmei(String sitenmei) {
        this.sitenmei = sitenmei;
    }
    
    /**
     * xXdbԍԋpB
     * @return xXdbԍ
     */
    public String getSitentel() {
        return sitentel;
    }
    
    /**
     * xXdbԍݒ肷B
     * @param sitentel xXdbԍ
     */
    public void setSitentel(String sitentel) {
        this.sitentel = sitentel;
    }
    
}
