/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.transaction;

import jp.terasoluna.fw.batch.commonj.transaction.JobResultInfoHandler;
import jp.terasoluna.fw.batch.jobmessage.JobMessageInfo;
import jp.terasoluna.fw.dao.UpdateDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class JobResultInfoHandlerImpl
implements JobResultInfoHandler {
    private static Log log = LogFactory.getLog(JobResultInfoHandlerImpl.class);
    private UpdateDAO updateDAO = null;
    private PlatformTransactionManager transactionManager = null;
    private static final String INSERT_JOB_RESULT = "jobResult.INSERT_JOB_RESULT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handle(JobMessageInfo jobMessageInfo) {
        this.printDebugLog("Job result registration processing starting.", jobMessageInfo);
        int count = 0;
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(null);
        try {
            count = this.updateDAO.execute(INSERT_JOB_RESULT, (Object)jobMessageInfo);
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! JobID: ");
            logStr.append(jobMessageInfo.getJobId());
            logStr.append(" ");
            logStr.append(throwable.getMessage());
            log.error((Object)logStr.toString(), throwable);
        }
        finally {
            if (count == 1) {
                this.transactionManager.commit(transactionStatus);
                this.printDebugLog("Job result registration processing success.", jobMessageInfo);
            } else {
                this.transactionManager.rollback(transactionStatus);
                this.printErrorLog("Job result registration processing failure.", jobMessageInfo);
            }
        }
        return count;
    }

    private void printDebugLog(String message, JobMessageInfo jobMessageInfo) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append(": [jobId=");
            builder.append(jobMessageInfo.getJobId());
            builder.append("] [jobRequestNo=");
            builder.append(jobMessageInfo.getJobRequestNo());
            builder.append("] [partitionNo=");
            builder.append(jobMessageInfo.getPartitionNo());
            builder.append("] [partitionKey=");
            builder.append(jobMessageInfo.getPartitionKey());
            builder.append("] [jobExitCode=");
            builder.append(jobMessageInfo.getJobExitCode());
            builder.append("] [JobState=");
            builder.append(jobMessageInfo.getJobState());
            builder.append("]");
            log.debug((Object)builder.toString());
        }
    }

    private void printErrorLog(String message, JobMessageInfo jobMessageInfo) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(": [jobId=");
        builder.append(jobMessageInfo.getJobId());
        builder.append("] [jobRequestNo=");
        builder.append(jobMessageInfo.getJobRequestNo());
        builder.append("] [partitionNo=");
        builder.append(jobMessageInfo.getPartitionNo());
        builder.append("] [partitionKey=");
        builder.append(jobMessageInfo.getPartitionKey());
        builder.append("] [jobExitCode=");
        builder.append(jobMessageInfo.getJobExitCode());
        builder.append("] [JobState=");
        builder.append(jobMessageInfo.getJobState());
        builder.append("]");
        log.error((Object)builder.toString());
    }

    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

