/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;

import jp.terasoluna.fw.util.ProxyUtil;
import junit.framework.TestCase;


/**
 * {@link jp.terasoluna.fw.util.ProxyUtil} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * vLV֘Ã[eBeBNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.util.ProxyUtil
 */
public class ProxyUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ProxyUtilTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     */
    @Override
    protected void setUp() throws Exception {
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     */
    @Override
    protected void tearDown() throws Exception {
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ProxyUtilTest(String name) {
        super(name);
    }

    /**
     * testGetTargetClass01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() proxy:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    "Proxy object is null."<br>
     *         
     * <br>
     * vLVIuWFNgnull̏ꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetTargetClass01() throws Exception {
    	// eXg{
    	try {
    		ProxyUtil.getTargetClass(null);
    		fail();
    	} catch (IllegalArgumentException e) {
    		// OK
    		assertEquals("Proxy object is null.", e.getMessage());
    	}
    }

    /**
     * testGetTargetClass02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() proxy:Cglib2AopProxy<br>
     *                @JavaBeanIuWFNg<br>
     *         
     * <br>
     * ҒlF(߂l) Class:JavaBean.class<br>
     *         
     * <br>
     * vLVIuWFNgCGLIBō쐬ꂽꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetTargetClass02() throws Exception {
        // O
    	ProxyFactory pf = new ProxyFactory(new ProxyUtil_JavaBeanStub01());
    	pf.setProxyTargetClass(true);
        Object proxy = pf.getProxy();
        assertTrue(AopUtils.isCglibProxy(proxy));

        // eXg{
    	Class result = ProxyUtil.getTargetClass(proxy);

        // 
    	assertSame(ProxyUtil_JavaBeanStub01.class, result);
    }

    /**
     * testGetTargetClass03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() proxy:JavaBean<br>
     *         
     * <br>
     * ҒlF(߂l) Class:JavaBean.class<br>
     *         
     * <br>
     * ^[QbgIuWFNgɃvLVĂȂꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetTargetClass03() throws Exception {
        // eXg{
    	Class result = ProxyUtil.getTargetClass(new ProxyUtil_JavaBeanStub01());

        // 
    	assertSame(ProxyUtil_JavaBeanStub01.class, result);
    }

    /**
     * testGetTargetClass04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() proxy:JdkDynamicAopProxy<br>
     *                @JavaBean<br>
     *         
     * <br>
     * ҒlF(߂l) Class:JavaBean.class<br>
     *         
     * <br>
     * vLVIuWFNgProxyō쐬ꂽꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetTargetClass04() throws Exception {
    	// O
    	ProxyFactory pf = new ProxyFactory(new ProxyUtil_JavaBeanStub01());
        Object proxy = pf.getProxy();

        assertTrue(AopUtils.isJdkDynamicProxy(proxy));

        // eXg{
    	Class result = ProxyUtil.getTargetClass(proxy);

        // 
    	assertSame(ProxyUtil_JavaBeanStub01.class, result);
    }

    /**
     * testGetTargetClass05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() proxy:JdkDynamicAopProxy<br>
     *                @JdkDynamicAopProxy<br>
     *                @@@@JavaBean<br>
     *         
     * <br>
     * ҒlF(߂l) Class:JavaBean.class<br>
     *         
     * <br>
     * vLVIuWFNglXgProxyō쐬ꂽꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetTargetClass05() throws Exception {
        // O
    	ProxyFactory parentPf = new ProxyFactory(new ProxyUtil_JavaBeanStub01());
        Object parent = parentPf.getProxy();
        
        ProxyFactory pf = new ProxyFactory(parent);
        Object proxy = pf.getProxy();

        assertTrue(AopUtils.isJdkDynamicProxy(proxy));

        // eXg{
    	Class result = ProxyUtil.getTargetClass(proxy);

        // 
    	assertSame(ProxyUtil_JavaBeanStub01.class, result);
    }
}
