/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import org.springframework.instrument.InstrumentationSavingAgent;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class InstrumentationLoadTimeWeaver
implements LoadTimeWeaver {
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        Instrumentation instrumentation = InstrumentationSavingAgent.getInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("Must start with Java agent to use InstrumentationLoadTimeWeaver. See Spring documentation.");
        }
        instrumentation.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

