/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample000;

import java.util.Random;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.batch.functionsample.common.SeikyuData;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * T|[gNXB<br>
 * e[ũf[^NAAVKf[^쐬B<br>
 * f[^10łAe̓_ō쐬B<br>
 */
public class Sample000PreLogic04 implements SupportLogic<JobContext> {

    /**
     * ڋq
     */
    static final String[] aryCustname = {"AX","BX","CX","DX","EX","FX","GX","HX","IX","JX","KX"};
    
    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(Sample000PreLogic04.class);

    /**
     * xX
     */
    private static final String[] aryBranchcd = {"t",""};
    
    /**
     * S
     */
    private static final String[] aryTantosyaid = {"c","","","n",""};
    	
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO;
    
    /**
     * NB
     */
    public BLogicResult execute(JobContext jobContext) {

    if(log.isDebugEnabled()){
        log.debug("start.");
    }
    
    //e[ũf[^폜B
    updateDAO.execute("SAMPLE000.deleteSeikyu", null);
        
    //e[uɃf[^}B
    SeikyuData seikyu  = new SeikyuData();
    Random random = new Random();
    int tantosyaNo = 0;
    int custNo = 0;
    for(String branchcd : aryBranchcd){
        
        seikyu.setBranchcd(branchcd);
        tantosyaNo = 0;
        
        for(int j = 1; j <= 5; j++){
        seikyu.setCustname(aryCustname[custNo]);
        	seikyu.setSeikyutuki("2007/0" + j);
        	seikyu.setSeikyugaku(random.nextInt(100000) + 10000);
        	seikyu.setTantosyaid(aryTantosyaid[tantosyaNo]);
        	    
        	updateDAO.execute("SAMPLE000.insertSeikyu", seikyu);
        	custNo += random.nextInt(2);
        	tantosyaNo += random.nextInt(2);
        }
        custNo++;

    }
    
    if(log.isDebugEnabled()){
        log.debug("end.");
    }
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
    

}
