/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.reset;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.beans.IndexedBeanWrapper;
import jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.struts.form.FormEx;
import jp.terasoluna.fw.web.struts.ModuleUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;

/**
 * ftHg̃ZbgNXB
 *
 * <p>
 * TERASOLUNAftHgŗpӂĂ Resetter NXB<br>
 * ̃NX
 * {@link  jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn}
 * 𗘗pAXML t@Cɐݒ肳ꂽ
 * tH[tB[h̃ZbgsB<br>
 * ANVtH[reset()\bhgĂׁAZbg
 * Struts̃CtTCN݂̂ŎsBZbg̓`FbN{bNX
 * WI{^̒lvpeB̏ړIƂĒ񋟂ׁA
 * ̖̑ړIł̗pɂĂ͓͕ۏ؂ȂB<br>
 * PɃtB[hꍇ́ArWlXWbNȂǂʂA
 * f̒lύXƂĎs邱ƁBStruts̃CtTCNł̓ZbgsA
 * NGXgp[^ł̃vpeBēxB<br>
 * <br>
 * Zbg͑Ώۂ̃tB[h̒lnull̏ꍇA^肪łȂׁA
 * null̂܂܁AlύXsȂBnullȊOObject^tB[hnulllɁA
 * boolean^falseɁȂ̃v~eBu^tB[h0ɏsB
 * DynaValidatorActionFormExgpꍇA
 * struts-config.xmlɋLqlɂ̓ZbgȂ̂ŁAӂ邱ƁB<br>
 * Zbg@\ƂāA wʏ̃Zbgx y ww͈̓Zbg@\x
 * Aw͈̓Zbg@\ł́Az񖔂 List IuWFNg
 * Cӂ͈݂̔͂̂Zbg鎖\B<br>
 * ZbgCӂ͈̔͂̓NGXgp[^ &quot;startIndex&quot;,
 * &quot;endIndex&quot;L[ƂĊi[ĂKvB
 * </p>
 *
 * <strong>gp@</strong><br>
 * tH[Zbg`t@C(reset.xml)ɂ̓ANVƂ
 * ZbgΏۃtB[hݒ肷B <code><pre>
 *  &lt;reset&gt;
 *    &lt;action path=&quot;/resetAction&quot;&gt;
 *      &lt;property-reset name=&quot;field1&quot; /&gt;
 *      &lt;property-reset name=&quot;field2&quot; select=&quot;true&quot; /&gt;
 *    &lt;/action&gt;
 *  &lt;/reset&gt;
 * </pre></code> L̐ݒ̏ꍇA/resetAction.do Ă΂
 * NGXgp[^tH[ɔfOɃtH[
 * w̃tB[hNAB<br>
 * NAΏۂ̃tB[h property-reset ^O name Ŏw肳ꂽA
 * &quot;field1&quot; 
 * &quot;field2&quot; ƂȂB<br>
 * &quot;field2&quot; ɂẮA select  true ƂȂĂׁA
 * NGXgp^&quot;startIndex&quot; ` &quot;endIndex&quot;
 * Ŏw肳ꂽCfbNXԂ̃tB[hl݂̂ null
 * ɏB<br>
 * ܂A{NX̓lXgvpeB̃ZbgɑΉĂB
 * ANVtH[̃lXgvpeBZbgꍇ́A
 * vpeBu.vŘAQƎgp邱ƁB
 * ȉɁAlXgvpeBZbgꍇ̗B<br><br>
 * <strong>lXgvpeB̃Zbg@</strong><br>
 * <code><pre>
 * public class MyActionForm extends ValidatorActionFormEx {
 *     private List<Row> rows = null;
 *     public void setRows(List<Row> rows) {
 *         this.rows = rows;
 *     }
 *     public List<Row> getRows() {
 *         return this.rows;
 *     }
 *     private Map<String, String> map = new HashMap();
 *     //ȉȗ
 * }
 * public class Row {
 *     private String value = null;
 *     public void setValue(String value) {
 *         this.value = value;
 *     }
 *     public String getValue() {
 *         return this.value;
 *     }
 * }
 * </pre></code>
 * LMyActionFormRowNX̃Xg̊evaluevpeBA
 * Map^mapvpeBŁufieldvƂL[̒l
 * Zbgꍇ͈ȉ̂悤reset.xmlɋLqB
 * <code><pre>
 *  &lt;reset&gt;
 *    &lt;action path=&quot;/resetAction&quot;&gt;
 *      &lt;property-reset name=&quot;rows.value&quot; /&gt;
 *      &lt;property-reset name=&quot;map(field)&quot; /&gt;
 *    &lt;/action&gt;
 *  &lt;/reset&gt;
 * </pre></code>
 * QƎ̓vpeB݂̂LqBvfzList̏ꍇ
 * t[[NIɔFASĂ̗vfZbgB
 * ʏ̃vpeBlAselecttruew肷邱ƂŁA
 * ͈͎w胊Zbg\łB
 *
 * @see jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn
 * @see jp.terasoluna.fw.web.struts.reset.ActionReset
 * @see jp.terasoluna.fw.web.struts.reset.FieldReset
 * @see jp.terasoluna.fw.web.struts.reset.ResetterResources
 * @see jp.terasoluna.fw.web.struts.form.FormEx
 * @see jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx
 * @see jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx
 *
 */
public class ResetterImpl implements Resetter {

    /**
     * ONX
     */
    private static Log log = LogFactory.getLog(ResetterImpl.class);

    /**
     * tH[̃tB[hl̃ZbgsB
     *
     * @param form
     *            ANVtH[
     * @param mapping
     *            }bsO
     * @param request
     *            NGXg
     *
     * @see jp.terasoluna.fw.web.struts.plugins.ResetterPlugIn
     * @see jp.terasoluna.fw.web.struts.reset.ActionReset
     * @see jp.terasoluna.fw.web.struts.reset.FieldReset
     * @see jp.terasoluna.fw.web.struts.reset.ResetterResources
     * @see jp.terasoluna.fw.web.struts.form.FormEx
     * @see jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx
     * @see jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx
     */
    public void reset(FormEx form, ActionMapping mapping,
            HttpServletRequest request) {
        // form,mappingnull̏ꍇ͂܂œBȂ̂
        // NullPointer͍lȂ
        if (log.isDebugEnabled()) {
            log.debug(mapping.getName() + " reset() called.");
        }
        ActionReset reset = getActionReset(mapping, request);
        if (reset == null) {
            return;
        }
        Iterator<String> it = reset.getFieldNames();
        IndexedBeanWrapper wrapper = new JXPathIndexedBeanWrapperImpl(form);
        while (it.hasNext()) {

            // tB[h擾
            String fieldName = it.next();
            if (log.isDebugEnabled()) {
                log.debug("reset[" + fieldName + "]");
            }

            Map<String, Object> propMap =
                wrapper.getIndexedPropertyValues(fieldName);
            // selectw肳Ăꍇ͎w͈͂̂݃Zbg
            // AAtB[hzAListłȂꍇ͒ʏ̃Zbgs
            if (reset.isSelectField(fieldName) && propMap.size() > 1) {
                resetSelectField(form, propMap, request);
            } else {
                for (Entry<String, Object> e : propMap.entrySet()) {
                    resetValue(form, e);
                }
            }
        }
    }

    /**
     * ANVtH[̎w肳ꂽvpeBZbgB
     * vpeB̌^boolean^ABoolean^̏ꍇfalseݒ肷B
     * ̑̃v~eBu^т̃bp[^̏ꍇ́A0ݒ肷B
     * vpeB̌^bp[^ȊOObject^̏ꍇnullݒ肷B<br>
     * Aentryɂnulln邱Ƃ͂ȂB
     *
     * @param form ݂̃NGXgŎgpANVtH[
     * @param entry ZbgΏۂ̃vpeBƌ݂̒l̃Gg
     * @throws PropertyAccessException vpeB̒lݒɎsꍇ
     */
    protected void resetValue(FormEx form, Entry<String, Object> entry) {
        if (log.isDebugEnabled()) {
            log.debug("resetValue(" + form + ", " +
                    entry.getKey() + ") called.");
        }
        String propName = entry.getKey();
        try {
            Object value = entry.getValue();
            if (value == null) {
                return;
            }
            Class type = null;
            type = value.getClass();
            if (type != null) {
                // ^̎ނŏ킯B
                if (type == Boolean.TYPE || type == Boolean.class) {
                    BeanUtil.setBeanProperty(form, propName, Boolean.FALSE);
                } else if (type == Byte.TYPE || type == Byte.class) {
                    BeanUtil.setBeanProperty(
                            form, propName, new Byte((byte) 0));
                } else if (type == Character.TYPE || type == Character.class) {
                    BeanUtil.setBeanProperty(form, propName,
                            new Character((char) 0));
                } else if (type == Double.TYPE || type == Double.class) {
                    BeanUtil.setBeanProperty(form, propName,
                            new Double(0.0));
                } else if (type == Float.TYPE || type == Float.class) {
                    BeanUtil.setBeanProperty(form, propName,
                            new Float((float) 0.0));
                } else if (type == Integer.TYPE || type == Integer.class) {
                    BeanUtil.setBeanProperty(
                            form, propName, new Integer(0));
                } else if (type == Long.TYPE || type == Long.class) {
                    BeanUtil.setBeanProperty(form, propName, new Long(0));
                } else if (type == Short.TYPE || type == Short.class) {
                    BeanUtil.setBeanProperty(
                            form, propName, new Short((short) 0));
                } else {
                    // v~eBu^Abp[^łȂꍇnullݒ肷
                    BeanUtil.setBeanProperty(form, propName, null);
                }
            }
        } catch (PropertyAccessException e) {
            log.error("cannot access property " + form + "." + propName, e);
        }
    }

    /**
     * ResetterResources ̃CX^X擾B
     *
     * @param request NGXg
     * @return ResetterResources CX^X
     * @see jp.terasoluna.fw.web.struts.reset.ActionReset
     * @see jp.terasoluna.fw.web.struts.reset.FieldReset
     */
    protected ResetterResources getResetterResources(
            HttpServletRequest request) {

        // Prefix擾
        String prefix = ModuleUtil.getPrefix(request);

        // ServletContext擾
        ServletContext application = RequestUtil.getServletContext(request);

        // ResetterResource擾
        ResetterResources resources = (ResetterResources) application
                .getAttribute(ResetterResources.RESETTER_RESOURCES_KEY + prefix);

        return resources;
    }

    /**
     * ANVpXɕRÂ ActionReset ̃CX^X擾B
     *
     * @param mapping ݂̃NGXg̃}bsO
     * @param request NGXg
     * @return ActionReset ̃CX^X
     * @see jp.terasoluna.fw.web.struts.reset.FieldReset
     * @see jp.terasoluna.fw.web.struts.reset.ResetterResources
     */
    protected ActionReset getActionReset(ActionMapping mapping,
            HttpServletRequest request) {

        ResetterResources resources = getResetterResources(request);
        if (resources == null) {
            if (log.isDebugEnabled()) {
                log.debug("ResetterResources is null.");
            }
            return null;
        }

        ActionReset reset = resources.get(mapping.getPath());

        if (reset == null) {
            if (log.isDebugEnabled()) {
                log.debug("action path:" + mapping.getPath()
                        + " is not specified to reset.");
            }
        }
        return reset;

    }

    /**
     * ItB[h̃ZbgsB
     *
     * select  true ݒ肳ĂƂ NGXgp^
     * &quot;startIndex&quot; ` &quot;endIndex&quot;
     * Ŏw肳ꂽCfbNXԂ̃tB[hl null ɏB<br>
     * NGXgp^ &quot;startIndex&quot;, &quot;endIndex&quot;
     * ܂܂ĂȂΑSĂ̗vf̃ZbgsB<br>
     * ܂AtB[hľ^z^AList ^Ő錾Ăꍇ́A
     * ʏ̃ZbgsB
     *
     * @param form ݂̃NGXgŎgpANVtH[
     * @param propMap vpeBƌ݂̒lMap
     * @param request NGXg
     *
     * @see jp.terasoluna.fw.web.struts.reset.ActionReset
     * @see jp.terasoluna.fw.web.struts.reset.FieldReset
     * @see jp.terasoluna.fw.web.struts.reset.ResetterResources
     */
    protected void resetSelectField(FormEx form,
                                    Map<String, Object> propMap,
                                    HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("resetSelectField() called.");
        }
        int startIndex = 0;
        int size = propMap.size();
        int endIndex = size;
        try {
            String startIndexStr = request.getParameter("startIndex");
            String endIndexStr = request.getParameter("endIndex");
            if (startIndexStr != null) {
                startIndex = Integer.parseInt(startIndexStr);
            }
            if (endIndexStr != null) {
                endIndex = Integer.parseInt(endIndexStr);
            }
            if (log.isDebugEnabled()) {
                log.debug("startIndex = [" + startIndex + "]");
                log.debug("endIndex = [" + endIndex + "]");
            }
        } catch (NumberFormatException e) {
            log.error("startIndex or endIndex is not Number.", e);
            return;
        }

        // ZbgsB
        Set<Map.Entry<String, Object>> set = propMap.entrySet();
        int index = 0;
        for (Entry<String, Object> e : set) {
            if (index >= startIndex &&
                    startIndex < size && index <= endIndex && index < size) {
                resetValue(form, e);
            }
            index++;
        }
    }
}
