/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.controlbreak;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakChunk;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakProcessor;
import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobWorker;

public class ControlBreakWorker
extends JobWorker {
    private ControlBreakProcessor controlBreakProcessor = null;

    public void work(Chunk chunk, JobStatus jobStatus) {
        ControlBreakChunk controlBreakChunk = (ControlBreakChunk)chunk;
        super.work(chunk, jobStatus);
        if (!jobStatus.isContinue()) {
            return;
        }
        ArrayList<LinkedHashMap<String, Object>> batchUpdateMapList = new ArrayList<LinkedHashMap<String, Object>>();
        if (controlBreakChunk.size() > 1) {
            this.controlBreakProcessor.doChunkControlBreak(controlBreakChunk, jobStatus, batchUpdateMapList);
        }
        if (jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY) {
            this.processBatchUpdate(controlBreakChunk.getJobContext(), jobStatus, batchUpdateMapList);
            return;
        }
        if (!jobStatus.isContinue()) {
            return;
        }
        if (controlBreakChunk.isEndChunk()) {
            if (controlBreakChunk.size() > 1) {
                this.controlBreakProcessor.doAllTransChunkControlBreak(controlBreakChunk, jobStatus, batchUpdateMapList);
            }
        } else {
            this.controlBreakProcessor.doTransChunkControlBreak(controlBreakChunk, jobStatus, batchUpdateMapList);
        }
        if (jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY || jobStatus.isContinue()) {
            this.processBatchUpdate(controlBreakChunk.getJobContext(), jobStatus, batchUpdateMapList);
        }
    }

    public void setControlBreakProcessor(ControlBreakProcessor controlBreakProcessor) {
        this.controlBreakProcessor = controlBreakProcessor;
    }
}

