/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.service.blogic;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.thin.tutorial.service.bean.UserBean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ͏o^rWlXWbNB
 *
 * ʂ͂ꂽlf[^x[Xɓo^B
 *
 */
public class RegisterBLogicImpl implements RegisterBLogic{

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(RegisterBLogicImpl.class);

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO = null;

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;

    /**
     * UpdateDAOԋpB
     *
     * @return ێUpdateDAO
     */
    public UpdateDAO getUpdateDAO() {
        return updateDAO;
    }

    /**
     * UpdateDAOݒ肷B
     *
     * @param updateDAO UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getQueryDAO() {
        return queryDAO;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param queryDAO QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * ͂ꂽf[^x[Xɓo^B
     * o^ɐԋpB
     *
     * @param bean ʂɂē͂ꂽlێBean
     * @return o^
     */
    public boolean register(UserBean bean) {

        if (log.isDebugEnabled()) {
            log.debug("register Start.");
        }

        //d`FbNs
        //G[̏ꍇ́AfalseԋpB
        if (!check(bean)) {
            return false;
        }

        //o^AʌԋpB
        updateDAO.execute("insertUser", bean);

        return true;
    }

    /**
     * ͂ꂽIDdۂf[^x[X擾Ĕ肷B
     * dĂꍇ́AfalseԋpB
     * dĂȂꍇ́AtrueԋpB
     *
     * @param bean ʂɂē͂ꂽlێBean
     * @return `FbN
     */
    protected boolean check(UserBean bean) {

        if (log.isDebugEnabled()) {
            log.debug("check Start.");
        }

        //IDf[^B
        Map<String, Long> params = new HashMap<String, Long>();
        params.put("ID", bean.getId());
        Map<String, Object>[] result
            = queryDAO.executeForMapArray("getUser", params);

        //IDŌAf[^擾łꍇ́AdG[ƂB
        if (result != null && result.length > 0) {
            return false;
        }

        //f[^擾łȂꍇ́AdĂȂƂ
        //trueԋpB
        return true;
    }
}
