/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessages;

/**
 * <p><code>changeStyleClass</code>^O̎NXB</p>
 *
 * <p>w肵tB[hɂẴG[񂪐ݒ肳Ă邩ǂɂāA
 * X^CV[g̃NX̐؂ւsB<br>
 * ANVtH[̃tB[hɃG[ꍇɁÃtB[h
 * ԎɂȂǂ̕\ύXꍇɗpB</p>
 * <h5>^OT|[g鑮</h5>
 * <p><code>changeStyleClass</code> ^Oł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>name</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      G[񂪐ݒ肳Ă邩ǂ
 *      肷tB[hB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>default</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      G[Ȃꍇ̃X^CV[gNXB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>error</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *      G[ꍇ̃X^CV[gNXB
 *    </td>
 *   </tr>
 * </table>
 * </div>
 * <br><br>
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 * <br>
 * <h5>gp@</h5>
 * <p><code><pre>
 * &lt;td class='&lt;ts:changeStyleClass name="mou1"
 *    default="gaid" error="error"/&gt;'&gt;
 *   &lt;input type="text" name="mou1"&gt;
 * &lt;/td&gt;
 * </pre></code></p>
 */
public class ChangeStyleClassTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 8969715040525132492L;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(ChangeStyleClassTag.class);
    
    /**
     * G[񂪐ݒ肳Ă邩ǂ𔻒肷tB[hB
     */
    private String name = null;

    /**
     * tB[hɃG[Ȃꍇ̃X^CV[g̃NXB
     */
    private String defaultValue = null;

    /**
     * tB[hɃG[ꍇ̃X^CV[g̃NXB
     */
    private String errorValue = null;

    /**
     * tB[hݒ肷B
     *
     * @param name tB[h
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * tB[hɃG[Ȃꍇ̃X^CV[g̃NXݒ肷B
     *
     * @param value G[Ȃꍇ̃X^CV[g̃NX
     */
    public void setDefault(String value) {
        this.defaultValue = value;
    }

    /**
     * tB[hɃG[ꍇ̃X^CV[g̃NXݒ肷B
     *
     * @param value G[ꍇ̃X^CV[g̃NX
     */
    public void setError(String value) {
        this.errorValue = value;
    }

    /**
     * w肳ꂽtB[hɃG[񂪐ݒ肳Ă邩ǂɂāA
     * X^CV[g̃NXԋpB
     *
     * @param req HTTPNGXg
     * @param fieldName tB[h
     * @param ifNormal G[Ȃꍇ̃X^CV[g̃NX
     * @param ifError G[ꍇ̃X^CV[g̃NX
     * @return X^CV[g̃NX
     */
    private String chooseClass(HttpServletRequest req,
                               String fieldName,
                               String ifNormal,
                               String ifError) {
        ActionMessages errors = (ActionMessages)
            req.getAttribute(Globals.ERROR_KEY);
        if (errors == null) {
            HttpSession session = req.getSession(true);
            errors = (ActionMessages) session.getAttribute(Globals.ERROR_KEY);
            if (errors == null) {
                return ifNormal;
            }
        }
        Iterator iter = errors.get(fieldName);
        int errorCount = 0;
        while (iter.hasNext()) {
            iter.next();
            errorCount++;
        }
        return (errorCount == 0) ? ifNormal : ifError;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     * G[̗Lɂďo͂X^CV[gNXύXB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {
        HttpServletRequest req
            = (HttpServletRequest) pageContext.getRequest();
        if (req == null) {
            return SKIP_BODY;
        }
        String result = chooseClass(req,
                                    this.name,
                                    this.defaultValue,
                                    this.errorValue);
        try {
            JspWriter out = pageContext.getOut();
            out.print(result);
        } catch (IOException e) {
            log.error("Output failed.");
            throw new JspTagException(e.toString());
        }
        return EVAL_BODY_INCLUDE;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
        this.name = null;
        this.defaultValue = null;
        this.errorValue = null;
    }

}
