/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.SimpleConnectionHandle;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        super.beginTransaction(entityManager, definition);
        Session session = this.getSession(entityManager);
        FlushMode flushMode = session.getFlushMode();
        FlushMode previousFlushMode = null;
        if (definition.isReadOnly()) {
            session.setFlushMode(FlushMode.MANUAL);
            previousFlushMode = flushMode;
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setFlushMode(FlushMode.AUTO);
            previousFlushMode = flushMode;
        }
        return new SessionTransactionData(session, previousFlushMode);
    }

    public void cleanupTransaction(Object transactionData) {
        ((SessionTransactionData)transactionData).resetFlushMode();
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        Session session = this.getSession(entityManager);
        Connection con = session.connection();
        return con != null ? new SimpleConnectionHandle(con) : null;
    }

    protected Session getSession(EntityManager em) {
        return ((HibernateEntityManager)em).getSession();
    }

    private static class SessionTransactionData {
        private final Session session;
        private final FlushMode previousFlushMode;

        public SessionTransactionData(Session session, FlushMode previousFlushMode) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
        }

        public void resetFlushMode() {
            if (this.previousFlushMode != null) {
                this.session.setFlushMode(this.previousFlushMode);
            }
        }
    }
}

