/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.Cglib2AopProxy;
import org.springframework.aop.framework.JdkDynamicAopProxy;
import org.springframework.util.ClassUtils;

public class DefaultAopProxyFactory
implements AopProxyFactory {
    private static final boolean cglibAvailable = ClassUtils.isPresent("net.sf.cglib.proxy.Enhancer", (class$org$springframework$aop$framework$DefaultAopProxyFactory == null ? (class$org$springframework$aop$framework$DefaultAopProxyFactory = DefaultAopProxyFactory.class$("org.springframework.aop.framework.DefaultAopProxyFactory")) : class$org$springframework$aop$framework$DefaultAopProxyFactory).getClassLoader());
    static /* synthetic */ Class class$org$springframework$aop$framework$DefaultAopProxyFactory;
    static /* synthetic */ Class class$org$springframework$aop$SpringProxy;

    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface()) {
                return new JdkDynamicAopProxy(config);
            }
            if (!cglibAvailable) {
                throw new AopConfigException("Cannot proxy target class because CGLIB2 is not available. Add CGLIB to the class path or specify proxy interfaces.");
            }
            return CglibProxyFactory.createCglibProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class[] interfaces = config.getProxiedInterfaces();
        return interfaces.length == 0 || interfaces.length == 1 && (class$org$springframework$aop$SpringProxy == null ? (class$org$springframework$aop$SpringProxy = DefaultAopProxyFactory.class$("org.springframework.aop.SpringProxy")) : class$org$springframework$aop$SpringProxy).equals(interfaces[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CglibProxyFactory {
        private CglibProxyFactory() {
        }

        public static AopProxy createCglibProxy(AdvisedSupport advisedSupport) {
            return new Cglib2AopProxy(advisedSupport);
        }
    }
}

