/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.pagelink.service;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.thin.functionsample.pagelink.bean.UserBean;
import jp.terasoluna.fw.dao.QueryDAO;

/**
 * ꗗ擾rWlXWbNB
 *
 * f[^x[Xʂɕ\錏݈̂ꗗ(Tu~bggp)擾B
 * ܂Aꗗ̑S擾B
 *
 */
public class ListSubmitServiceImpl implements ListSubmitService {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    protected QueryDAO dao = null;

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getDao() {
        return dao;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param dao QueryDAO
     */
    public void setDao(QueryDAO dao) {
        this.dao = dao;
    }

    /**
     * f[^x[Xꗗ擾B
     * 1y[W̕\ƊJnCfbNX擾AQueryDAOɓnB
     * ܂Aꗗ̑S擾ԋpB
     *
     * @param map \AJnCfbNXێMap
     * @return ꗗASێMap
     */
    public Map<String, Object> getUserList(Map<String, String> map) {
        
        String strIndex = map.get("startIndex");
        String strRow = map.get("row");
        
        int startIndex = 0;
        int row = 5;
        if (strIndex != null) {
            try {
                startIndex = Integer.parseInt(strIndex);
            } catch (NumberFormatException e) {
                startIndex = 0;
            }
        }
        if (strRow != null) {
            try {
                row = Integer.parseInt(strRow);
            } catch (NumberFormatException e) {
                row = 5;
            }
        }
        
        UserBean[] bean = dao.executeForObjectArray(
                "pageLink.selectUserList", null,
                UserBean.class, startIndex, row);

        Map<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("totalCount", getUserCount());
        retMap.put("userBeans3", bean);
        
        return retMap;

    }

    /**
     * ꗗ̑S擾ĕԋpB
     *
     * @return 擾
     */
    private String getUserCount() {

        String count
            = dao.executeForObject(
                    "pageLink.selectUserCount", null, String.class);
        if (count == null || "".equals(count)) {
            count = "0";
        }
        return count;
    }
}
