/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.jndi.service;

import java.util.Map;

import jp.terasoluna.fw.web.jndi.JndiSupport;

/**
 * IJNDIAoChT[rX
 *
 */
public class JndiUnbindServiceImpl implements JndiUnbindService {
    /**
     * JNDIXg擾T[rX
     */
    protected ListJndiService listJndiService = null;
    /**
     * JNDIT|[gNX
     */
    protected JndiSupport jndiSupport = null;
    /**
     * jndiSupport擾B
     * @return jndiSupport
     */
    public JndiSupport getJndiSupport() {
        return jndiSupport;
    }
    /**
     * jndiSupportݒ肷B
     * @param jndiSupport jndiSupportB
     */
    public void setJndiSupport(JndiSupport jndiSupport) {
        this.jndiSupport = jndiSupport;
    }
    /**
     * listJndiService擾B
     * @return listJndiService
     */
    public ListJndiService getListJndiService() {
        return listJndiService;
    }
    /**
     * listJndiServiceݒ肷B
     * @param listJndiService listJndiServiceB
     */
    public void setListJndiService(ListJndiService listJndiService) {
        this.listJndiService = listJndiService;
    }
    
    /**
     * YJNDIAoChB
     * JNDI\[XXg擾B
     *
     * @param name JNDI
     * @return JNDI\[XXg
     */
    public Map<String, Object> jndiUnbind(String name){
        Map<String, Object> retMap = null;
        
        // IlUnbind 
        jndiSupport.unbind(name);
        
        retMap = listJndiService.getListJndi();
        return retMap;
    }
}