/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.dispatch.service;

import java.util.Map;

import jp.terasoluna.thin.functionsample.dispatch.bean.UserDivisionVO;
import jp.terasoluna.fw.dao.UpdateDAO;

/**
 * [UXVT[rX̎NX
 *
 */
public class UpdateUserDivisionServiceImpl implements
        UpdateUserDivisionService {
    
    
    /**
     * [UXVpDAONX<br>
     * SpringɂCX^Xݒ肳B
     */
    protected UpdateDAO updateDAO = null;
    
    /**
     * ͂ꂽf[^Ƀf[^x[X̃[UXVB
     *
     * @param params ͂ꂽ[U 
     * @exception Exception \ʗO
     */
    public void updateUserDivision(Map params) throws Exception {
        //[UR[h̎擾
        String[] userCodes = (String[]) params.get("userCode");
        //[U̎擾
        String[] userDivision = (String[]) params.get("userDivision");
        
        //f[^x[X̃f[^̍XV
        for (int i = 0; i < userCodes.length; i++) {
            updateDAO.execute("dispatch.updateUserDivision",
                    new UserDivisionVO(userCodes[i], userDivision[i]));
        }
    }

    /**
     * [UXVpDAONX擾B
     * @return [UXVpDAONX
     */
    public UpdateDAO getUpdateDAO() {
        return updateDAO;
    }

    /**
     * [UXVpDAONXݒ肷B
     * @param updateDAO [UXVpDAONX
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

}