/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.authorization.web;

import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.thin.functionsample.common.FunctionUVO;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.UserValueObject;
import jp.terasoluna.fw.web.thin.AuthorizationController;

/**
 * @\ԗTvAP̃ANZX`FbNRg[
 * 
 */
public class FunctionAuthorizationController implements AuthorizationController {

    /**
     * ONXB
     */
    private Log log =
        LogFactory.getLog(FunctionAuthorizationController.class);
    
    /**
     * ANZX`FbNΏۃpX
     */
    private List<String> listCheckRequiredPath = null;
    
    /**
     * FǗ
     */
    private static final String AUTH_ADMIN = "0";
    
    /**
     * ANZX`FbNsB
     * ZbVUVO擾AANZX`FbNB
     * ǗҌ̏ꍇtrueԂA
     * ȊȌꍇfalseԂB
     * 
     * @param pathInfo pX
     * @param req ServletRequest
     * @return ǗҌ̏ꍇtrueԂAȊȌꍇfalseԂB
     */
    public boolean isAuthorized(String pathInfo, ServletRequest req) {
        
        if (log.isDebugEnabled()) {
            log.debug("isAuthorized() strated.");
        }
        
        // ZbV擾
        HttpSession session = ((HttpServletRequest) req).getSession();

        // ZbVUserValueObject擾
        FunctionUVO uvo = (FunctionUVO) session.getAttribute(
                UserValueObject.USER_VALUE_OBJECT_KEY);
        
        // ANZXĂ邩`FbN
        if (AUTH_ADMIN.equals(uvo.getAuth())) {
            return true;
        }
        
        if (log.isDebugEnabled()) {
            log.debug("isAuthorized() ended.");
        }
        
        return false;
    }

    /**
     * ANZX`FbNKvȂtrueAKvȂȂfalseԂB
     * @param ServletRequest req
     * @return boolean `FbNKvȂtrueAKvȂȂfalseԂB
     */
    public boolean isCheckRequired(ServletRequest req) {
        
        if (log.isDebugEnabled()) {
            log.debug("isCheckRequired() strated.");
        }
        
        for (String path : listCheckRequiredPath) {
            if ((RequestUtil.getPathInfo(req)).equals(path)) {
                return true;
            }            
        }
        
        if (log.isDebugEnabled()) {
            log.debug("isCheckRequired() ended.");
        }

        return false;
    }

    /**
     * listCheckRequiredPath擾B
     * @return listCheckRequiredPath
     */
    public List<String> getListCheckRequiredPath() {
        return listCheckRequiredPath;
    }

    /**
     * listCheckRequiredPathݒ肷B
     * @param listCheckRequiredPath listCheckRequiredPathB
     */
    public void setListCheckRequiredPath(List<String> listCheckRequiredPath) {
        this.listCheckRequiredPath = listCheckRequiredPath;
    }
}