/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * ZbVw肳ꂽvpeB폜B
 *
 * <p>
 *  Bean`t@CɎw肳ꂽL[̃XgA
 *  ZbV폜L[擾폜sB<br>
 * </p>
 *
 * <p>
 *  Jڐ́A&lt;action&gt;vf
 *  parameterɎw肳ꂽAhXɃtH[h邽߁A
 *  parameterK{ƂȂB
 *  āALBean`t@Cystruts-config.xml
 *  ݒłB
 * </p>
 * <p>
 *  <strong>Bean`t@CClearSessionActionݒ</strong>
 * <code><pre>
 * &lt;bean name="/clearSessionAction" singleton="false"
 *   class="jp.terasoluna.fw.web.struts.actions.ClearSessionAction"&gt;
 *   <strong>&lt;property name="clearSessionKeys"&gt;
 *   &lt;list&gt;
 *     &lt;value&gt;userAddress&lt;/value&gt;
 *     &lt;value&gt;userPhoneNo&lt;/value&gt;
 *     &lt;value&gt;sampleSession&lt;/value&gt;
 *   &lt;/list&gt;
 *   &lt;/property&gt;</strong>
 * &lt;/bean&gt;
 * </pre></code>
 * </p>
 * <p>
 *  <strong>struts-config.xml̐ݒ</strong>
 * <code><pre>
 * &lt;action path="/clearSessionAction"
 *   name="_sampleForm"
 *   scope="session"
 *   parameter="/sessionCleared.do"&gt;
 * &lt;/action&gt;
 * </pre></code>
 * LݒɂAANVpX&quot;/clearSessionAction&quot;
 * sƁAclearSessionKeysvpeB폜Ώۂ̃L[
 * ƂȂǍʁAuserAddressAuserPhoneNoAsampleSessionƂ
 * 3̃ZbVL[QƂZbV񂪍폜B<br>
 * ݂̃ZbV̂̂jꍇ́ALogoffActionQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.LogoffAction
 *
 */
public class ClearSessionAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(ClearSessionAction.class);
    
    /**
     * G[y[Wi404jJڎsG[R[hB
     */
    private static final String FORWARD_ERRORPAGE_ERROR = 
        "error.forward.errorpage";

    /**
     * ZbV폜L[̃XgB
     */
    private List clearSessionKeys = null;

    /**
     * ZbV폜L[̃XgݒB
     *
     * @param clearSessionKeys ZbV폜L[̃Xg
     */
    public void setClearSessionKeys(List clearSessionKeys) {
        this.clearSessionKeys = clearSessionKeys;
    }

    /**
     * ZbVNAsAʂփtH[hB
     * <p>
     *  폜Ώۂ̃L[PȂꍇ́A
     *  JڐԋpAIB
     * </p>
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request <code>HTTP</code>NGXg
     * @param response <code>HTTP</code>X|X
     * @return Jڐ
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                     ActionForm form,
                                     HttpServletRequest request,
                                     HttpServletResponse response) {

        HttpSession session = request.getSession();

        if (clearSessionKeys != null) {
            for (int cnt = 0; cnt < clearSessionKeys.size(); cnt++) {
                String sKey = (String) clearSessionKeys.get(cnt);
                if (log.isDebugEnabled()) {
                    log.debug("removing [" + sKey + "] from HttpSession");
                }
                //ZbV폜s
                session.removeAttribute(sKey);
            }
        }

        // p[^itH[hj擾
        String path = mapping.getParameter();

        if (path == null) {
            // p[^ݒ肳ĂȂꍇA(404)G[ԋp
            try {
                response.sendError(HttpServletResponse.SC_NOT_FOUND);
            } catch (IOException e) {
                log.error("Error page(404) forwarding failed.");
                
                throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
            }
            return null;
        }

        // ANVtH[h𐶐
        ActionForward retVal = new ActionForward(path);

        return retVal;

    }
}
