/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.Proxy;

import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

/**
 *  vLV֘Ã[eBeBNXB
 *
 */
public class ProxyUtil {
    /**
     * vLṼ^[QbgNX擾B
     * @param proxy vLVIuWFNgB
     * @return w肵vLṼ^[QbgNXB
     */
    public static Class getTargetClass(Object proxy) {
        // Null`FbN
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy object is null.");
        }
        if (AopUtils.isCglibProxy(proxy)) {
            return proxy.getClass().getSuperclass();
        }
        if (proxy instanceof Advised) {
            // 擾^[QbgvLV̏ꍇAlXg^[Qbg擾
            do {
                proxy = getAdvisedTarget((Advised) proxy);
            } while (Proxy.isProxyClass(proxy.getClass()));
        }
        return proxy.getClass();
    }
    /**
     * vLṼ^[Qbg擾B
     * @param advised IuWFNgB
     * @return w肵vLṼ^[QbgIuWFNgB
     * @throws CannotGetTargetException 
     */
    private static Object getAdvisedTarget(Advised advised) {
        try {
            return advised.getTargetSource().getTarget();
        } catch (Exception e) {
            // ^[Qbg擾łȂꍇ̗OB
            throw new CannotGetTargetException(e);
        }
    }
}
