/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.access;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.access.MBeanClientInterceptor;
import org.springframework.jmx.access.MBeanInfoRetrievalException;
import org.springframework.util.ClassUtils;

public class MBeanProxyFactoryBean
extends MBeanClientInterceptor
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean {
    private Class proxyInterface;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object mbeanProxy;

    public void setProxyInterface(Class managementInterface) {
        this.proxyInterface = managementInterface;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws MBeanServerNotFoundException, MBeanInfoRetrievalException {
        super.afterPropertiesSet();
        if (this.proxyInterface == null) {
            throw new IllegalArgumentException("Property 'proxyInterface' is required");
        }
        this.mbeanProxy = new ProxyFactory(this.proxyInterface, this).getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        return this.mbeanProxy;
    }

    public Class getObjectType() {
        return this.proxyInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

