/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSingletonBeanRegistry
implements SingletonBeanRegistry {
    private static final Object NULL_OBJECT = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map singletonObjects = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Set registeredSingletons = CollectionFactory.createLinkedSetIfPossible(16);
    private final Set singletonsCurrentlyInCreation = Collections.synchronizedSet(new HashSet());
    private boolean singletonsCurrentlyInDestruction = false;
    private final Map disposableBeans = CollectionFactory.createLinkedMapIfPossible(16);
    private final Map dependentBeanMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        Assert.notNull(beanName, "'beanName' must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            Object oldObject = this.singletonObjects.get(beanName);
            if (oldObject != null) {
                throw new IllegalStateException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there is already object [" + oldObject + "] bound");
            }
            this.addSingleton(beanName, singletonObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSingleton(String beanName, Object singletonObject) {
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.put(beanName, singletonObject != null ? singletonObject : NULL_OBJECT);
            this.registeredSingletons.add(beanName);
        }
    }

    public Object getSingleton(String beanName) {
        Assert.notNull(beanName, "'beanName' must not be null");
        Object singletonObject = this.singletonObjects.get(beanName);
        return singletonObject != NULL_OBJECT ? singletonObject : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleton(String beanName, ObjectFactory singletonFactory) {
        Assert.notNull(beanName, "'beanName' must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            Object singletonObject = this.singletonObjects.get(beanName);
            if (singletonObject == null) {
                if (this.singletonsCurrentlyInDestruction) {
                    throw new BeanCreationNotAllowedException(beanName, "Singleton bean creation not allowed while the singletons of this factory are in destruction (Do not request a bean from a BeanFactory in a destroy method implementation!)");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
                }
                this.beforeSingletonCreation(beanName);
                try {
                    singletonObject = singletonFactory.getObject();
                }
                finally {
                    this.afterSingletonCreation(beanName);
                }
                this.addSingleton(beanName, singletonObject);
            }
            return singletonObject != NULL_OBJECT ? singletonObject : null;
        }
    }

    protected void removeSingleton(String beanName) {
        Assert.notNull(beanName, "'beanName' must not be null");
        this.singletonObjects.remove(beanName);
        this.registeredSingletons.remove(beanName);
    }

    public boolean containsSingleton(String beanName) {
        Assert.notNull(beanName, "'beanName' must not be null");
        return this.singletonObjects.containsKey(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonNames() {
        Map map = this.singletonObjects;
        synchronized (map) {
            return StringUtils.toStringArray(this.registeredSingletons);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSingletonCount() {
        Map map = this.singletonObjects;
        synchronized (map) {
            return this.registeredSingletons.size();
        }
    }

    protected void beforeSingletonCreation(String beanName) {
        if (!this.singletonsCurrentlyInCreation.add(beanName)) {
            throw new BeanCurrentlyInCreationException(beanName);
        }
    }

    protected void afterSingletonCreation(String beanName) {
        if (!this.singletonsCurrentlyInCreation.remove(beanName)) {
            throw new IllegalStateException("Singleton '" + beanName + "' isn't currently in creation");
        }
    }

    public final boolean isSingletonCurrentlyInCreation(String beanName) {
        return this.singletonsCurrentlyInCreation.contains(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisposableBean(String beanName, DisposableBean bean) {
        Map map = this.disposableBeans;
        synchronized (map) {
            this.disposableBeans.put(beanName, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentBean(String beanName, String dependentBeanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            Set dependencies = (Set)this.dependentBeanMap.get(beanName);
            if (dependencies == null) {
                dependencies = CollectionFactory.createLinkedSetIfPossible(8);
                this.dependentBeanMap.put(beanName, dependencies);
            }
            dependencies.add(dependentBeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDependentBean(String beanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            return this.dependentBeanMap.containsKey(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getDependentBeans(String beanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            return Collections.unmodifiableSet((Set)this.dependentBeanMap.get(beanName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in " + this));
        }
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonsCurrentlyInDestruction = true;
        }
        map = this.disposableBeans;
        synchronized (map) {
            String[] disposableBeanNames = StringUtils.toStringArray(this.disposableBeans.keySet());
            for (int i = disposableBeanNames.length - 1; i >= 0; --i) {
                this.destroySingleton(disposableBeanNames[i]);
            }
        }
        map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.clear();
            this.registeredSingletons.clear();
            this.singletonsCurrentlyInDestruction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingleton(String beanName) {
        Map map = this.singletonObjects;
        synchronized (map) {
            this.removeSingleton(beanName);
        }
        DisposableBean disposableBean = null;
        Map map2 = this.disposableBeans;
        synchronized (map2) {
            disposableBean = (DisposableBean)this.disposableBeans.remove(beanName);
        }
        this.destroyBean(beanName, disposableBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBean(String beanName, DisposableBean bean) {
        Set dependencies = null;
        Map map = this.dependentBeanMap;
        synchronized (map) {
            dependencies = (Set)this.dependentBeanMap.remove(beanName);
        }
        if (dependencies != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved dependent beans for bean '" + beanName + "': " + dependencies));
            }
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependentBeanName = (String)it.next();
                this.destroySingleton(dependentBeanName);
            }
        }
        if (bean != null) {
            try {
                bean.destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Destroy method on bean with name '" + beanName + "' threw an exception"), ex);
            }
        }
    }

    protected final Object getSingletonMutex() {
        return this.singletonObjects;
    }
}

