/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInfo;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.DefaultAdvisorChainFactory;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    private static final long serialVersionUID = 2651364800145442165L;
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    transient AdvisorChainFactory advisorChainFactory;
    private transient Map methodCache;
    private List interfaces = new ArrayList();
    private List advisors = new LinkedList();
    private Advisor[] advisorArray = new Advisor[0];
    static /* synthetic */ Class class$org$springframework$aop$framework$AdvisedSupport;

    public AdvisedSupport() {
        this.initDefaultAdvisorChainFactory();
    }

    public AdvisedSupport(Class[] interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    private void initDefaultAdvisorChainFactory() {
        this.setAdvisorChainFactory(new DefaultAdvisorChainFactory());
        this.methodCache = CollectionFactory.createIdentityMapIfPossible(32);
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    public void setTargetSource(TargetSource targetSource) {
        this.targetSource = targetSource != null ? targetSource : EMPTY_TARGET_SOURCE;
    }

    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setTargetClass(Class targetClass) {
        this.targetSource = EmptyTargetSource.forClass(targetClass);
    }

    public Class getTargetClass() {
        return this.targetSource.getTargetClass();
    }

    public void setAdvisorChainFactory(AdvisorChainFactory advisorChainFactory) {
        Assert.notNull(advisorChainFactory, "AdvisorChainFactory must not be null");
        this.advisorChainFactory = advisorChainFactory;
    }

    public AdvisorChainFactory getAdvisorChainFactory() {
        return this.advisorChainFactory;
    }

    public void setInterfaces(Class[] interfaces) {
        Assert.notNull(interfaces, "Interfaces must not be null");
        this.interfaces.clear();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addInterface(interfaces[i]);
        }
    }

    public void addInterface(Class intf) {
        Assert.notNull(intf, "Interface must not be null");
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("[" + intf.getName() + "] is not an interface");
        }
        if (!this.interfaces.contains(intf)) {
            this.interfaces.add(intf);
            this.adviceChanged();
        }
    }

    public boolean removeInterface(Class intf) {
        return this.interfaces.remove(intf);
    }

    public Class[] getProxiedInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean isInterfaceProxied(Class intf) {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class proxyIntf = (Class)it.next();
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    public final Advisor[] getAdvisors() {
        return this.advisorArray;
    }

    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    public void addAdvisor(int pos, Advisor advisor) throws AopConfigException {
        if (advisor instanceof IntroductionAdvisor) {
            this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    public boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void removeAdvisor(int index) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: Configuration is frozen.");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: " + "This configuration only has " + this.advisors.size() + " advisors.");
        }
        Advisor advisor = (Advisor)this.advisors.get(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (int j = 0; j < ia.getInterfaces().length; ++j) {
                this.removeInterface(ia.getInterfaces()[j]);
            }
        }
        this.advisors.remove(index);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    public int indexOf(Advisor advisor) {
        Assert.notNull(advisor, "Advisor must not be null");
        return this.advisors.indexOf(advisor);
    }

    public boolean replaceAdvisor(Advisor a, Advisor b) throws AopConfigException {
        Assert.notNull(a, "Advisor a must not be null");
        Assert.notNull(b, "Advisor b must not be null");
        int index = this.indexOf(a);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b);
        return true;
    }

    public void addAllAdvisors(Advisor[] advisors) {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (!ObjectUtils.isEmpty(advisors)) {
            for (int i = 0; i < advisors.length; ++i) {
                Advisor advisor = advisors[i];
                if (advisor instanceof IntroductionAdvisor) {
                    this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
                }
                Assert.notNull(advisor, "Advisor must not be null");
                this.advisors.add(advisor);
            }
            this.updateAdvisorArray();
            this.adviceChanged();
        }
    }

    private void validateIntroductionAdvisor(IntroductionAdvisor advisor) {
        advisor.validateInterfaces();
        Class[] ifcs = advisor.getInterfaces();
        for (int i = 0; i < ifcs.length; ++i) {
            this.addInterface(ifcs[i]);
        }
    }

    private void addAdvisorInternal(int pos, Advisor advisor) throws AopConfigException {
        Assert.notNull(advisor, "Advisor must not be null");
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (pos > this.advisors.size()) {
            throw new IllegalArgumentException("Illegal position " + pos + " in advisor list with size " + this.advisors.size());
        }
        this.advisors.add(pos, advisor);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    protected final void updateAdvisorArray() {
        this.advisorArray = this.advisors.toArray(new Advisor[this.advisors.size()]);
    }

    protected final List getAdvisorsInternal() {
        return this.advisors;
    }

    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors.size();
        this.addAdvice(pos, advice);
    }

    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        Assert.notNull(advice, "Advice must not be null");
        if (advice instanceof IntroductionInfo) {
            this.addAdvisor(pos, new DefaultIntroductionAdvisor(advice, (IntroductionInfo)((Object)advice)));
        } else {
            if (advice instanceof DynamicIntroductionAdvice) {
                throw new AopConfigException("DynamicIntroductionAdvice may only be added as part of IntroductionAdvisor");
            }
            this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
        }
    }

    public boolean removeAdvice(Advice advice) throws AopConfigException {
        int index = this.indexOf(advice);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public int indexOf(Advice advice) {
        Assert.notNull(advice, "Advice must not be null");
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return i;
        }
        return -1;
    }

    public boolean adviceIncluded(Advice advice) {
        Assert.notNull(advice, "Advice must not be null");
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return true;
        }
        return false;
    }

    public int countAdvicesOfType(Class adviceClass) {
        Assert.notNull(adviceClass, "Advice class must not be null");
        int count = 0;
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() == null || !adviceClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getInterceptorsAndDynamicInterceptionAdvice(Method method, Class targetClass) {
        Map map = this.methodCache;
        synchronized (map) {
            List cached = (List)this.methodCache.get(method);
            if (cached == null) {
                cached = this.advisorChainFactory.getInterceptorsAndDynamicInterceptionAdvice(this, null, method, targetClass);
                this.methodCache.put(method, cached);
            }
            return cached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adviceChanged() {
        Map map = this.methodCache;
        synchronized (map) {
            this.methodCache.clear();
        }
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyConfigurationFrom(other, other.targetSource, new ArrayList(other.advisors));
    }

    protected void copyConfigurationFrom(AdvisedSupport other, TargetSource targetSource, List advisors) {
        this.copyFrom(other);
        this.targetSource = targetSource;
        this.advisorChainFactory = other.advisorChainFactory;
        this.interfaces = new ArrayList(other.interfaces);
        Iterator it = advisors.iterator();
        while (it.hasNext()) {
            Advisor advisor = (Advisor)it.next();
            if (advisor instanceof IntroductionAdvisor) {
                this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
            }
            Assert.notNull(advisor, "Advisor must not be null");
            this.advisors.add(advisor);
        }
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    protected Object writeReplace() {
        AdvisedSupport copy = this;
        if (!this.getClass().equals(class$org$springframework$aop$framework$AdvisedSupport == null ? (class$org$springframework$aop$framework$AdvisedSupport = AdvisedSupport.class$("org.springframework.aop.framework.AdvisedSupport")) : class$org$springframework$aop$framework$AdvisedSupport)) {
            copy = new AdvisedSupport();
            copy.copyConfigurationFrom(this);
        }
        return copy;
    }

    private Object readResolve() {
        this.initDefaultAdvisorChainFactory();
        return this;
    }

    public String toProxyConfigString() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append(this.interfaces.size()).append(" interfaces ");
        sb.append(ClassUtils.classNamesToString(this.interfaces)).append("; ");
        sb.append(this.advisors.size()).append(" advisors ");
        sb.append(this.advisors).append("; ");
        sb.append("targetSource [").append(this.targetSource).append("]; ");
        sb.append(super.toString());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

