/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedCodeListLoader
implements CodeListLoader {
    private Map<String, String> codeListMap = null;
    private List<CodeBean> codeLists = null;

    public Map getCodeListMap() {
        return this.codeListMap;
    }

    public void setCodeListMap(Map<String, String> codeListMap) {
        this.codeListMap = codeListMap;
    }

    @Override
    public void load() {
        if (this.codeLists != null) {
            return;
        }
        if (this.codeListMap == null) {
            this.codeLists = Collections.unmodifiableList(new ArrayList());
            return;
        }
        ArrayList<CodeBean> list = new ArrayList<CodeBean>();
        for (String key : this.codeListMap.keySet()) {
            String value = this.codeListMap.get(key);
            CodeBean cb = new CodeBean();
            cb.setId(key);
            cb.setName(value);
            list.add(cb);
        }
        this.codeLists = Collections.unmodifiableList(list);
    }

    @Override
    public CodeBean[] getCodeBeans() {
        if (this.codeLists == null) {
            return new CodeBean[0];
        }
        CodeBean[] cb = new CodeBean[this.codeLists.size()];
        return this.codeLists.toArray(cb);
    }
}

