/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.usequeue;

import commonj.work.WorkItem;
import jp.terasoluna.fw.batch.commonj.WorkerExecutorService;
import jp.terasoluna.fw.batch.commonj.usequeue.WorkManagerTaskWorkQueue;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkQueueFactory;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

public class WorkManagerTaskWorkQueueFactory
implements WorkQueueFactory {
    private int queueLength = 0;
    private QueueProcessor queueProcessor = null;
    private WorkerExecutorService workerExecutorService = null;
    private int multiplicity = 1;
    private long workTimeout = Long.MAX_VALUE;

    public WorkQueue getWorkQueue(JobStatus jobStatus) {
        WorkManagerTaskWorkQueue workQueue = new WorkManagerTaskWorkQueue(this.queueLength, jobStatus);
        workQueue.setWorkManager(this.workerExecutorService.getWorkManager());
        workQueue.setWorkTimeout(this.workTimeout);
        for (int i = 0; i < this.multiplicity; ++i) {
            WorkItem workItem = this.workerExecutorService.submit(this.queueProcessor, workQueue, jobStatus);
            workQueue.addWorkItem(workItem);
        }
        return workQueue;
    }

    public void setQueueLength(int queueLength) {
        if (queueLength <= 0) {
            StringBuffer buffer = new StringBuffer("QueueLength is illegal. ");
            buffer.append(queueLength);
            throw new InitializeException(buffer.toString());
        }
        this.queueLength = queueLength;
    }

    public void setQueueProcessor(QueueProcessor queueProcessor) {
        this.queueProcessor = queueProcessor;
    }

    public void setWorkerExecutorService(WorkerExecutorService workerExecutorService) {
        this.workerExecutorService = workerExecutorService;
    }

    public void setMultiplicity(int multiplicity) {
        if (multiplicity <= 0) {
            StringBuffer buffer = new StringBuffer("Multiplicity is illegal. ");
            buffer.append(multiplicity);
            throw new InitializeException(buffer.toString());
        }
        this.multiplicity = multiplicity;
    }

    public void setWorkTimeout(long workTimeout) {
        this.workTimeout = workTimeout;
    }
}

