/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import java.util.Map;
import java.util.Properties;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
/**
 * bZ[W\[XNXB
 *
 * <p>
 * bZ[W\[X@\Ƃ́AJSPŕ\G[bZ[WȂǁA
 * ̃L[ɑ΂ăbZ[W擾@\łB<br>
 * ̃NXgp邱ƂɂāAbZ[W\[X`t@C
 * iʏStrutsŎgvpeBt@C`̃bZ[W\[XjłȂA
 * NX[hDBQƂADB̃bZ[W\[Xgp邱Ƃ
 * \łB
 * </p>
 * 
 * <h5>Tvp</h5>
 * 
 * <p>
 * DBŐݒ肳ꂽbZ[W\[X́ASW[
 * L邪AbZ[W\[X`t@C̃bZ[W\[X́A
 * Struts̊eW[ƂɓƗB
 * ȉTvpāÃNXgpƂɁAbZ[W\[X@\
 * ǂ̂悤ɐUB
 * </p>
 * 
 * <h6>Tvݒ</h6>
 * <p>
 * ƂāAW[AAW[BƂ̃W[݂A
 * W[̃bZ[W\[X̐ݒibZ[W\[X`t@Cj
 * L̂悤Ȏw肪ƂB<br>
 * <br>
 * <table border="1">
 *   <caption>bZ[W\[Xꗗ</caption>
 *   <tr>
 *     <td>W[</td>
 *     <td>bZ[WL[</td>
 *     <td>bZ[W</td>
 *     <td>bZ[W̓o^</td>
 *   </tr>
 *   <tr>
 *     <td rowspan="2">W[A</td>
 *     <td>message.propMessageResource</td>
 *     <td>"moduleA"</td>
 *     <td>bZ[W\[X`t@C</td>
 *   </tr>
 *   <tr>
 *     <td>message.dbMessageResource</td>
 *     <td>"DB"</td>
 *     <td>DB</td>
 *   </tr>
 *   <tr>
 *     <td rowspan="2">W[B</td>
 *     <td>message.propMessageResource</td>
 *     <td>"moduleB"</td>
 *     <td>bZ[W\[X`t@C</td>
 *   </tr>
 *   <tr>
 *     <td>message.subMessageResource</td>
 *     <td>"subModule"</td>
 *     <td>bZ[W\[X`t@C</td>
 *   </tr>
 * </table>
 * </p>
 * 
 * <h6>W[Ԃ̃bZ[W\[X̉͈</h6>
 * ̕\ŁAW[ÃbZ[W\[X̉͈͂́A
 * <ul>
 *   <li>W[AŒ`ꂽbZ[W\[X`t@C
 *       <code>message.propMessageResource</code>
 *   </li>
 *   <li>DB̃bZ[W\[Xł<code>message.dbMessageResource</code>
 *   </li>
 * </ul>
 * łB<br>
 * W[B̃bZ[W\[X̉͈͂́A
 * <ul>
 *   <li>W[BŒ`ꂽbZ[W\[X`t@C
 *       <code>message.propMessageResource</code></li>
 *   <li>W[BŒ`ꂽbZ[W\[X`t@C
 *       <code>message.subMessageResource</code></li>
 *   <li>W[ADB̃bZ[W\[Xł
 *       <code>message.dbMessageResource</code></li>
 * </ul>
 * łB<br>
 * W[AƃW[Bł́AbZ[W\[X̃L[
 * <code>message.propMessageResource</code>Ă邪AeW[
 * 擾ł郁bZ[ẂA
 * <ul>
 *   <li>W[A"moduleA"</li>
 *   <li>W[B"moduleB"</li>
 * </ul>
 * ƂȂB
 * bZ[W\[X`t@Cɂ郁bZ[W\[X̐ݒɊւẮA
 * eW[ԂŐݒ͋LłȂƂɒӂB<br>
 * ɑ΂AW[ԂŋLDB̃bZ[W\[X́A
 * <code>message.dbMessageResource</code>ɑ΂Ď擾ł郁bZ[ẂA
 * W[AAW[BƂ "DB"łB<br>
 * ܂AStruts̎dlƂāAW[B̃bZ[W\[X`t@C
 * ݒ肳ꂽbZ[W\[XW[A擾邱Ƃ͂łȂB
 * iW[A<code>module.subMessageResource</code>̃L[
 * QƂĂAbZ[W͎擾łȂBj
 * <h6>ӓ_</h6>
 * ̂悤ɁAbZ[W\[ẌɂĂ͉L̒ӓ_B
 * <ul>
 *   <li>bZ[W\[X`t@Cɒ`ꂽbZ[W
 *       擾悤ƂꍇAbZ[WL[`ĂĂA
 *       ݒ肳ꂽW[قȂȂ΁Agp郂W[ɂ
 *       lقȂ</li>
 *   <li>DBɃbZ[W\[Xݒ肵ꍇÃW[ł
 *       QƂ\</li>
 *   <li>DB̃bZ[W\[XƃbZ[W\[X`t@C
 *       bZ[W\[XŃL[̎AbZ[W\[X`t@C
 *       bZ[W擾</li>
 *   <li>DBMessageResourcespꍇAۉΉ͈؂ȂB
 *       DB擾郁bZ[W\[XłȂAbZ[W\[X`
 *       t@CP[ɉĕpӂĂAӖ͂ȂB<br>
 *       ۉΉsKvꍇAstruts-config.xml
 *       &lt;message-resources&gt;vffactoryŁAStruts񋟂
 *       PropertyMessageResourcesFactoryTERASOLUNA̒񋟂
 *       PropertyMessageResourcesExFactorypKvB
 *       ȂȀꍇDB̃bZ[W\[X͎擾łȂȂB</li>
 * </ul>
 * ܂AP̃L[ɑ΂āADBMessageResources̃bZ[W擾D揇ʂ́A
 * L̒ʂƂȂB<br>
 * <ol>
 *   <li>bZ[W\[X`t@CŒ`ꂽbZ[W\[X</li>
 *   <li>DBɒ`ꂽbZ[W\[X</li>
 *   <li>ƖʃbZ[W\[X`t@C
 *       iapplication-messages.propertiesj
 *       `ꂽbZ[W\[X</li>
 *   <li>VXebZ[W\[X`t@C
 *       isystem-messages.propertiesj
 *       `ꂽbZ[W\[X</li>
 * </ol>
 * ƖʃbZ[W\[XEVXebZ[W\[XɊւéA
 * {@link GlobalMessageResources}QƂ̂ƁB
 * 
 * <h5>gp@</h5>
 * ̃NX𗘗pɂ́AStrutsݒt@C(struts-config.xml)
 * &lt;message-resource&gt;vfɁA
 * <ul>
 *   <li>parameterɃbZ[W\[X`t@C
 *       gq(<code>.properties</code>)菜</li>
 *   <li>factoryɁA<code>DBMessageResourcesFactory</code></li>
 * </ul>
 * w肷BLStrutsݒt@C(struts-config.xml)̐ݒłB<br>
 * <code><pre>
 * &lt;struts-config&gt;
 *   c
 *   &lt;message-resources parameter="MessageResources"
 *                      factory="jp.terasoluna.fw.web.struts.action.DBMessageResourcesFactory"
 *   /&gt;
 *   c
 * &lt;/struts-config&gt;
 * </pre></code>
 * 
 * <h5>DB̃bZ[W\[X擾ݒ</h5>
 * DB烁bZ[W\[X擾邽߂ɁAVXeݒvpeBt@C
 * isystem.propertiesjŁAL̂悤ɐݒ肷B
 * <pre><code>
 * messages.sql=&lt;SQL(SELECT)&gt;
 * messages.dao=MessageResourcesDAO̎NX
 * </code></pre>
 *
 *
 * ̗͈ȉ̂悤ɂȂB
 * <pre><code>
 * messages.sql=SELECT MESSAGE_KEY, MESSAGE_VALUE FROM MESSAGES
 * messages.dao=jp.terasoluna.fw.web.struts.action.MessageResourcesDAOImpl
 * </code></pre>
 * 
 * <h6>ݒ̒ӓ_</h6>
 * <ul>
 *  <li>ݒ肷SQĹAPJiLݒłMESSAGE_KEYjɃbZ[WL[
 *      ݒ肳AQJiMESSAGE_VALUEjɃbZ[Wi[
 *      ʃZbgԂ̂łȂ΂ȂȂB</li>
 *  <li>ݒ肷DAÓAMessageResourcesDAONXłȂ΂Ȃ炸A
 *      Ȃ̃RXgN^NXłȂ΂ȂȂB
 *      TERASOLUNA񋟂MessageResourcesDAOImpl͓C^tF[X
 *      AȂ̃RXgN^ĂB
 *      <strong>{@link MessageResourcesDAOImpl}̎gp@ɂĂ
 *      NXJavadocQƂ̂ƁB</strong></li>
 * </ul>
 * 
 * <h5>bZ[W\[X`t@CivpeBt@Cj
 *     bZ[W\[X̐ݒ</h5>
 * vpeBt@CpbZ[W\[X̒`́AvpeBt@C
 * `ǂɓo^B
 * <pre><code>
 * &lt;bZ[WL[&gt;=&lt;bZ[W&gt;
 * </code></pre>
 * ̗͈ȉ̂悤ɂȂB
 * <pre><code>
 * errors.requiredArray={0}Ԗڂ{1}͕K{͂łB
 * errors.alphaNumericStringArray={0}Ԗڂ{1}͔ppłȂĂ͂Ȃ܂B
 * </code></pre>
 *
 * @see jp.terasoluna.fw.web.struts.action.GlobalMessageResources
 * @see jp.terasoluna.fw.web.struts.action.DBMessageResourcesFactory
 * @see jp.terasoluna.fw.web.struts.action.MessageResourcesDAO
 * @see jp.terasoluna.fw.web.struts.action.MessageResourcesDAOImpl
 *
 */
public class DBMessageResources extends MessageResources {
    
    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 8244415315747028752L;

    /**
     * VXeݒvpeBt@Cisystem.propertiesj
     * DAO擾ۂɎgpL[B
     */
    public static final String MESSAGES_DAO = "messages.dao";
    
    /**
     * VXeݒvpeBt@Cisystem.propertiesj
     * SQL擾ۂɎgpL[B
     */
    public static final String MESSAGES_SQL = "messages.sql";   
 
    /**
     *  bZ[W̎擾s\G[R[hB
     */
    private static final String DB_MESSAGE_RESOURCES_ERROR
        = "errors.db.message.resources";
    
    /**
     *  bZ[W\[X̏s\G[R[hB
     */
    private static final String DB_MESSAGE_RESOURCES_ERROR_INIT
        = "errors.db.message.resources.init";
    
    /**
     * ONXB
     */ 
    @SuppressWarnings("hiding")
    private static Log log = LogFactory.getLog(DBMessageResources.class);

    /**
     * DB擾bZ[WL[ƃbZ[Wi[MapB
     * NXŋLB
     */
    private static Map dbMessages = null;

    /**
     * bZ[W\[X`t@C擾bZ[WL[
     * bZ[Wi[MapB
     * 
     * DB̃bZ[W\[XƂ͈قȂAStruts̃W[Pʂ
     * Ɨ邱ƂłB
     */
    private Map<String, String> messages = new HashMap<String, String>();

    /**
     * w肳ꂽp[^ɂDBMessageResources𐶐B
     *
     * @param factory bZ[W\[Xt@Ng
     * @param config bZ[W\[X`t@C
     */
    public DBMessageResources(MessageResourcesFactory factory,
                              String config) {
        super(factory, config);
        if (log.isDebugEnabled()) {
            log.debug("call DBMessageResources()");
        }
        // DB̃bZ[W\[Xݒ̎ADBbZ[W\[X擾B
        if (dbMessages == null) {
            dbInit();
        }
        propertyInit(config);
    }

    /**
     * w肳ꂽp[^ɂDBMessageResources𐶐B
     * 
     * @param factory bZ[W\[Xt@Ng
     * @param config bZ[W\[X`t@C
     * @param returnNull <code>org.apache.struts.util.MessageResources</code>
     *                   NX <code>returnNull</code>
     *                   <code>false</code> w莞AL[ɊY郁bZ[W
     *                   ݂Ȃꍇ???Locale.key???Ƃ`ŃbZ[W
     *                   ԋpB
     */
    public DBMessageResources(MessageResourcesFactory factory,
                              String config, boolean returnNull) {
        super(factory, config, returnNull);
        if (log.isDebugEnabled()) {
            log.debug("call DBMessageResources()");
        }
        // DB̃bZ[W\[Xݒ̎ADBbZ[W\[X擾B
        if (dbMessages == null) {
            dbInit();
        }
        propertyInit(config);
    }
    
    /**
     * DB̃bZ[WL[ƃbZ[W̃yA擾B
     */
    protected static void dbInit() {
        
        if (log.isDebugEnabled()) {
            log.debug("call dbInit()");
        }
        
        // xĂ΂ꂽƂ悤dbMessagesɋMapݒ
        dbMessages = new HashMap();
        
        // VXeݒvpeBt@Cisystem.propertiesjvpeB
        // 擾
        String daoName = PropertyUtil.getProperty(MESSAGES_DAO);
        String sql = PropertyUtil.getProperty(MESSAGES_SQL);
        if (daoName == null && sql == null) {
            // ǂ̃L[`ĂȂΏI
            return;
        } else if (daoName == null || sql == null) {
            // `ĂȂꍇ͌xOoāAI
            if (log.isWarnEnabled()) {
                log.warn("defined only one of the pair - " + MESSAGES_DAO
                         + " and " + MESSAGES_SQL + ".");
            }
            return;
        }
        
        // DAÕCX^X𐶐
        MessageResourcesDAO dao = null;
        try {
            dao = (MessageResourcesDAO) ClassUtil.create(daoName); 
        } catch (ClassLoadException e) {
            // `ĂNX[hłȂꍇ
            log.error("\"" + daoName + "\" cannot loaded.", e);
            throw new SystemException(e, DB_MESSAGE_RESOURCES_ERROR_INIT);
        } catch (ClassCastException e) {
            // `ĂNXMessageResourcesDAOĂȂꍇ
            log.error("\"" + daoName + "\" not implemented"
                      + " MessageResourcesDAO", e);
            throw new SystemException(e, DB_MESSAGE_RESOURCES_ERROR_INIT);
        }
        
        // Message̋l܂Map擾B
        dbMessages = dao.queryMessageMap(sql);

    }
    
    /**
     *  bZ[W\[X`t@C烁bZ[WL[ƃbZ[W
     *  yA擾B
     *
     * @param propertyFile bZ[W\[X`t@C
     */
    protected void propertyInit(String propertyFile) {
        Properties props = null;
        Iterator names = null;
        
        if (log.isDebugEnabled()) {
            log.debug("call propertyInit()");
        }
        
        // bZ[W\[X`t@C̃[h
        props = PropertyUtil.loadProperties(propertyFile);
        if (props == null) {
            log.error(
                "Message resources file \"" + propertyFile + "\" is illegal.");
            return;
        }
        // nbV}bvւ̋lߑւs
        names = props.keySet().iterator();
        while (names.hasNext()) {
            String key = (String) names.next();
            if (log.isDebugEnabled()) {
                log.debug(
                    "Saving property message key [" + key + "]"
                    + "value [" + props.getProperty(key) + "]");
            }
            messages.put(key, props.getProperty(key));
        }
    }



    /**
     * w肳ꂽL[ɂƂÂbZ[W擾B
     * L[قȂ郁bZ[W̒`ꏊɑ݂鎞A擾D揇ʂ
     * L̂悤ɂȂB
     * <ol>
     *  <li>bZ[W\[X`t@C̃bZ[W\[X</li>
     *  <li>DB̃bZ[WL[ƃbZ[W̓Ă郁bZ[W\[X
     *      </li>
     *  <li>ƖʃbZ[W\[Xt@C`t@C
     *      iapplication-messages.propertiesj̃bZ[W\[X</li>
     *  <li>VXebZ[W\[X`t@Cisystem-messages.propertiesj
     *      ̃bZ[W\[X</li>
     * </ol>
     * <p>
     *  ׂẴbZ[W\[XɏsȂꍇA
     *  邢́Aǂ̒`bZ[WL[ɊYl
     *  擾łȂꍇAreturnNullwɂāA
     *  nullA邢Strutš`i???Locale.key???jŕԋpB
     * </p>
     * <p>
     *  ȂAŎw肳Ă郍P[͍lȂB
     *  Ȃ킿getMessage(key)ƓB
     * </p>
     *
     * @param locale bZ[WP[BlȂ
     * @param key bZ[WL[
     * 
     * @return localekeyɑΉ郁bZ[W
     */
    @Override
    public String getMessage(Locale locale, String key) {
        MessageResources globalMessageResources = null;
        
        if (log.isDebugEnabled()) {
            log.debug("call getMessage(Locale, String)");
        }
        
        if (key == null || "".equals(key)) {
            log.error("Message key 'null' or empty not allowed.");
            throw new SystemException(
                null, DB_MESSAGE_RESOURCES_ERROR);
        }
        
        // bZ[W\[X`t@C̃bZ[W擾
        if (messages != null) {
            String retMessage = messages.get(key);
            if (retMessage != null) {
                return retMessage;
            }
        }

        // DB̃bZ[W擾
        if (dbMessages != null) {
            String retMessage = (String) dbMessages.get(key);
            if (retMessage != null) {
                return retMessage;
            }
        }

        // ƖʁEVXẽbZ[W擾
        globalMessageResources = GlobalMessageResources.getInstance();
        String retMessage = globalMessageResources.getMessage(locale, key);
        if (retMessage != null) {
            return retMessage;
        }
        
        // ǂɂȂꍇreturnNull̐ݒ̗LɉĕԂ̂ς
        if (!returnNull) {
            return "???" + messageKey(locale, key) + "???";
        }
        return null;        
    }

    /**
     * w肳ꂽL[ɂƂÂbZ[W擾B
     * L[قȂ郁bZ[W̒`ꏊɑ݂鎞A擾D揇ʂ
     * L̂悤ɂȂB
     * <ol>
     *  <li>bZ[W\[X`t@C</li>
     *  <li>DB̃bZ[WL[ƃbZ[W̓Ăe[u</li>
     *  <li>ƖʃbZ[W\[Xt@C`t@C
     *      iapplication-messages.propertiesj̃bZ[W</li>
     *  <li>VXebZ[W\[X`t@Cisystem-messages.propertiesj
     *      ̃bZ[W</li>
     * </ol>
     *  ׂẴbZ[W\[XɏsȂꍇA
     *  邢́Aǂ̒`bZ[WL[ɊYl
     *  擾łȂꍇAnullԋpB
     *
     * @param key bZ[WL[
     * 
     * @return keyɑΉ郁bZ[W
     */
    @Override
    public String getMessage(String key) {
        Locale locale = null;
        return getMessage(locale , key);
    }
    
}
