/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;


/**
 * UT Cu̐ݒiutlib.conf t@C̓ejێNXB
 * 
 */
public class UTLibConfig {

    /**
     * UTCu̐ݒt@C̖O
     */
    private static final String PROPS_FILE_NAME = "utlib.conf";
    
    /**
     * [hUTCuݒ
     */
    private static Properties properties = null;

    /**
     * ݒl擾B
     * 
     * @param key ݒL[
     * @return ݒl
     */
    public static String getProperty(String key) {

        if (properties == null) {
            properties = loadProperties(PROPS_FILE_NAME);
        }
        return properties.getProperty(key);
    }

    /**
     * ݒt@CǂݍށB
     * 
     * @param filename ݒt@C
     * @return t@C烍[hݒli[PropetiesCX^X
     */
    private static Properties loadProperties(String fileName) {
        
        // ݒt@C̃Xg[擾B
        InputStream is = UTLibConfig.class.getResourceAsStream("/" + fileName);
        if (is == null) {
            String msg = "ݒt@C '" + fileName + "' ݂܂I";
            throw new RuntimeException(msg);
        }

        // ݒt@C[hB
        Properties props = new Properties();
        try {
            props.load(is);
        } catch (IOException e) {
            String msg = "ݒt@C '" + fileName + 
                         "' ̃[hɎs܂!";
            throw new RuntimeException(msg, e);
        } finally {
            try {
                is.close();
            } catch (IOException e) {
                // ȂB
            }
        }
        return props;
    }
    
    /**
     * vCx[gRXgN^iCX^X͕sjB
     */
    private UTLibConfig() {
    }
}
