/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

/**
 * FilterConfig ̃bNAbvNXB
 * <BR><BR>
 * ɁATERASOLUNA t[[N̊g̒P̃eXgp̃NXŁA
 * ƖAvP[ṼeXgŕKvɂȂ邱Ƃ͂قƂǂȂƎvB
 * 
 */
public class MockFilterConfig implements FilterConfig {

    /**
     * tB^[
     */
    private String filterName = null;
    
    /**
     * ServletContext
     */
    private ServletContext servletContext = null;
    
    /**
     * p[^i[Map
     */
    private Map initParamMap = new HashMap();
    
    /**
     * @see javax.servlet.FilterConfig#getFilterName()
     */
    public String getFilterName() {
        return this.filterName;
    }

    /**
     * tB^ݒ肷B
     *
     * @param filterName tB^
     */
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    /**
     * @see javax.servlet.FilterConfig#getServletContext()
     */
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /**
     * ServletContextݒ肷B
     *
     * @param servletContext T[ubgReLXg
     */
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /**
     * @see javax.servlet.FilterConfig#getServletContext()
     */
    public String getInitParameter(String name) {
        String initParam = null;
        if (name != null && initParamMap.get(name) != null) {
            initParam = (String) initParamMap.get(name);
        }
        return initParam;
    }

    /**
     * p[^̓eݒ肷B
     *
     * @param name p[^
     * @param value p[^l
     */
    public void setInitParameter(String name, String value) {
        if (value != null) {
            initParamMap.put(name, value);
        } else {
            initParamMap.remove(name);
        }
    }

    /**
     * @see javax.servlet.FilterConfig#getInitParameterNames()
     */
    public Enumeration getInitParameterNames() {
        Set set = new HashSet();
        Iterator iter = this.initParamMap.values().iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return Collections.enumeration(set);
    }

}

