/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import jp.terasoluna.fw.util.StringUtil;

/**
 * <p>̗iAщEj̃zCgXy[X폜trim
 * ^O̎NXB</p>
 *
 * <p><code>jp.terasoluna.fw.util.StringUtil</code> NX
 * <code>trim()</code> \bhɂĕ̍ẼzCgXy[X
 * 폜B</p>
 *
 * <p>^ȎAXNveBOϐɂẮA
 * <code>jp.terasoluna.web.taglib.StringFormatterTagBase
 * </code> pBڍׂ
 * <code>jp.terasoluna.web.taglib.StringFormatterTagBase
 * </code> ̃hLgQƂ̂ƁB</p>
 *
 * <p>zCgXy[XƂĔf镶ɂẮA
 * <code>jp.terasoluna.fw.util.StringUtil</code> NX
 * hLgQƂ̂ƁB</p>
 *
 * <p><code>&quot;form0001&quot;</code> bean
 * <code>&quot;field001&quot;</code> vpeB̒lE
 * zCgXy[Xďo͂ɂ́Aȉ̂悤ɋLqB</p>
 *
 * <p>:<br>
 * <code><pre>
 *  &lt;t:trim name="form0001"
 *             property="field001" /&gt;
 * </pre></code></p>
 *
 * <p>L beañvpeBAJX^^Oŏo͂ɃXNveBOϐ
 * <code>&quot;trimmed&quot;</code>
 * փZbgꍇɂ́Aȉ̂悤ɋLqB</p>
 *
 * <p>:<br>
 * <code><pre>
 *  &lt;t:trim id="trimmed"
 *             name="form0001"
 *             property="field001" /&gt;
 * </pre></code></p>
 *
 * <p>ẼzCgXy[X錳̕beanoɁA
 * JX^^O <code>value</code>
 * ɂĎw肷ꍇɂ́Aȉ̂悤ɋLqB</p>
 *
 * <p>:<br>
 * <code><pre>
 *  &lt;t:trim value="EzCgXy[XO̕  " /&gt;
 * </pre></code></p>
 *
 * @see jp.terasoluna.fw.web.taglib.StringFormatterTagBase
 *
 */
public class TrimTag extends StringFormatterTagBase {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 8026613148973363578L;

    /**
     * SpXy[X̃gۑB
     */
    protected boolean zenkaku = false;

    /**
     * SpXy[X̃gۑ擾B
     *
     * @return SpXy[X̃gۑ
     */
    public boolean getZenkaku() {
        return this.zenkaku;
    }

    /**
     * SpXy[X̃gۑݒ肷B
     *
     * @param zenkaku SpXy[X̃gۑ
     */
    public void setZenkaku(boolean zenkaku) {
        this.zenkaku = zenkaku;
    }

    /**
     * <p>w肳ꂽ̉ẼzCgXy[X폜B</p>
     *
     * @param s tH[}bgΏۂ̕
     * @return iAщEj̃zCgXy[X폜ꂽ
     */
    @Override
    protected String doFormat(String s) {
    	if (zenkaku) {
    		return StringUtil.trimZ(s);
    	}
        return StringUtil.trim(s);
    }

}
