/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.init.JobControlTableHandler;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.openapi.SupportLogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 񓯊^WuNɂāAWusɎsT|[gB
 * 
 * <p>sWũWuǗe[űN󋵂uIvɍXVB</p>
 * 
 */
public class AsyncJobPostLogic implements SupportLogic<AsyncJobContext> {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(AsyncJobPostLogic.class);

    /**
     * WuǗe[unhB
     */
    private JobControlTableHandler jobControlTableHandler = null;

    /**
     * ObZ[WiُIpjB
     */
    private String failureMessage = "Failed in job result registration processing to DB by batch daemon";
    
    /**
     * ObZ[WiIpjB
     */
    private String successMessage = "Succeeded in job result registration processing to DB by batch daemon";
    

    /**
     * RXgN^
     *
     */
    public AsyncJobPostLogic() {
    }
    
    /**
     * RXgN^
     * 
     * @param faulureMessage ObZ[WiُIpj
     * @param successMessage ObZ[WiIpj
     */
    protected AsyncJobPostLogic(String faulureMessage, String successMessage) {
        this.failureMessage = faulureMessage;
        this.successMessage = successMessage;
    }

    /**
     * 񓯊^WuNɂāAWus㏈sB
     * 
     * @param jobContext Wu˗i[WuReLXg
     * @return 񓯊Wus㏈̏ʁBN󋵂XVłȂꍇ
     * ɂ́A<code>ReturnCode.ERROR_END</code>B
     */
    public BLogicResult execute(AsyncJobContext jobContext) {

        // WusDBf
        if (handle(jobContext.getJobInfo()) != 1) {
            printErrorLog(failureMessage, jobContext.getJobInfo().getJobId());
            return new BLogicResult(ReturnCode.ERROR_END);
        }
        
        if (log.isDebugEnabled()) {
            printDebugLog(successMessage, jobContext.getJobInfo().getJobId());
        }

        return new BLogicResult(ReturnCode.NORMAL_END);
    }

    /**
     * WuǗe[uւ̃nhO
     * 
     * @param jobInfo Wu˗
     * @return 
     */
    protected int handle(JobInfo jobInfo) {
        return jobControlTableHandler.updateJobEnd(jobInfo);
    }
    
    /**
     * WuǗe[unhݒ肷B
     * 
     * @param jobControlTableHandler WuǗe[unh
     */
    public void setJobControlTableHandler(
            JobControlTableHandler jobControlTableHandler) {
        this.jobControlTableHandler = jobControlTableHandler;
    }

    /**
     * fobNbZ[W̏óB
     * 
     * @param message ObZ[W
     * @param jobId Wuhc
     */
    private void printDebugLog(String message, String jobId) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(" : [jobId=");
        builder.append(jobId);
        builder.append("]");
        log.debug(builder.toString());
    }

    /**
     * G[bZ[W̏óB
     * 
     * @param message ObZ[W
     * @param jobId Wuhc
     */
    private void printErrorLog(String message, String jobId) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(" : [jobId=");
        builder.append(jobId);
        builder.append("]");
        log.error(builder.toString());
    }

}
