/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractHtmlInputElementTag
extends AbstractHtmlElementTag {
    public static final String ONFOCUS_ATTRIBUTE = "onfocus";
    public static final String ONBLUR_ATTRIBUTE = "onblur";
    public static final String ONCHANGE_ATTRIBUTE = "onchange";
    public static final String ACCESSKEY_ATTRIBUTE = "accesskey";
    public static final String DISABLED_ATTRIBUTE = "disabled";
    public static final String READONLY_ATTRIBUTE = "readonly";
    private String onfocus;
    private String onblur;
    private String onchange;
    private String accesskey;
    private String disabled;
    private String readonly;

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    protected String getOnfocus() {
        return this.onfocus;
    }

    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    protected String getOnblur() {
        return this.onblur;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    protected String getOnchange() {
        return this.onchange;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    protected String getAccesskey() {
        return this.accesskey;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    protected String getDisabled() {
        return this.disabled;
    }

    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    protected String getReadonly() {
        return this.readonly;
    }

    protected void writeDefaultAttributes(TagWriter tagWriter) throws JspException {
        super.writeDefaultAttributes(tagWriter);
        this.writeOptionalAttribute(tagWriter, ONFOCUS_ATTRIBUTE, this.getOnfocus());
        this.writeOptionalAttribute(tagWriter, ONBLUR_ATTRIBUTE, this.getOnblur());
        this.writeOptionalAttribute(tagWriter, ONCHANGE_ATTRIBUTE, this.getOnchange());
        this.writeOptionalAttribute(tagWriter, ACCESSKEY_ATTRIBUTE, this.getAccesskey());
        if (this.isDisabled()) {
            tagWriter.writeAttribute(DISABLED_ATTRIBUTE, DISABLED_ATTRIBUTE);
        }
        if (this.isReadonly()) {
            this.writeOptionalAttribute(tagWriter, READONLY_ATTRIBUTE, READONLY_ATTRIBUTE);
        }
    }

    protected boolean isDisabled() throws JspException {
        return "true".equals(this.evaluate(DISABLED_ATTRIBUTE, this.getDisabled()));
    }

    protected boolean isReadonly() throws JspException {
        return "true".equals(this.evaluate(READONLY_ATTRIBUTE, this.getReadonly()));
    }
}

